/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.PrefixFilteredDimensionSpec;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;

public class PrefixFilteredVirtualColumn
implements VirtualColumn {
    private final String name;
    private final DimensionSpec delegate;
    private final String prefix;

    @JsonCreator
    public PrefixFilteredVirtualColumn(@JsonProperty(value="name") String name, @JsonProperty(value="delegate") DimensionSpec delegate, @JsonProperty(value="prefix") String prefix) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.delegate = (DimensionSpec)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        this.prefix = (String)Preconditions.checkNotNull((Object)prefix, (Object)"prefix");
    }

    @Override
    @JsonProperty(value="name")
    public String getOutputName() {
        return this.name;
    }

    @JsonProperty
    public String getPrefix() {
        return this.prefix;
    }

    @JsonProperty
    public DimensionSpec getDelegate() {
        return this.delegate;
    }

    @Override
    public byte[] getCacheKey() {
        CacheKeyBuilder builder = new CacheKeyBuilder(5).appendString(this.name).appendCacheable(this.delegate).appendString(this.prefix);
        return builder.build();
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory factory) {
        return new PrefixFilteredDimensionSpec(this.delegate, this.prefix).decorate(factory.makeDimensionSelector(this.delegate));
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory factory) {
        return this.makeDimensionSelector(DefaultDimensionSpec.of(columnName), factory);
    }

    @Override
    public ColumnCapabilities capabilities(String columnName) {
        return new ColumnCapabilitiesImpl().setType(this.delegate.getOutputType()).setDictionaryEncoded(true).setHasBitmapIndexes(true);
    }

    @Override
    @Nullable
    public ColumnCapabilities capabilities(ColumnInspector inspector, String columnName) {
        return inspector.getColumnCapabilities(this.delegate.getDimension());
    }

    @Override
    public List<String> requiredColumns() {
        return Collections.singletonList(this.delegate.getDimension());
    }

    @Override
    public boolean usesDotNotation() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrefixFilteredVirtualColumn that = (PrefixFilteredVirtualColumn)o;
        return this.name.equals(that.name) && this.delegate.equals(that.delegate) && this.prefix.equals(that.prefix);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.delegate, this.prefix);
    }

    public String toString() {
        return "PrefixFilteredVirtualColumn{name='" + this.name + "', delegate=" + String.valueOf(this.delegate) + ", prefix='" + this.prefix + "'}";
    }
}

