/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluentImpl;
import io.kubernetes.client.openapi.models.V1NetworkPolicyEgressRule;
import io.kubernetes.client.openapi.models.V1NetworkPolicyEgressRuleBuilder;
import io.kubernetes.client.openapi.models.V1NetworkPolicyEgressRuleFluentImpl;
import io.kubernetes.client.openapi.models.V1NetworkPolicyIngressRule;
import io.kubernetes.client.openapi.models.V1NetworkPolicyIngressRuleBuilder;
import io.kubernetes.client.openapi.models.V1NetworkPolicyIngressRuleFluentImpl;
import io.kubernetes.client.openapi.models.V1NetworkPolicySpec;
import io.kubernetes.client.openapi.models.V1NetworkPolicySpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1NetworkPolicySpecFluentImpl<A extends V1NetworkPolicySpecFluent<A>>
extends BaseFluent<A>
implements V1NetworkPolicySpecFluent<A> {
    private ArrayList<V1NetworkPolicyEgressRuleBuilder> egress;
    private ArrayList<V1NetworkPolicyIngressRuleBuilder> ingress;
    private V1LabelSelectorBuilder podSelector;
    private List<String> policyTypes;

    public V1NetworkPolicySpecFluentImpl() {
    }

    public V1NetworkPolicySpecFluentImpl(V1NetworkPolicySpec instance) {
        if (instance != null) {
            this.withEgress(instance.getEgress());
            this.withIngress(instance.getIngress());
            this.withPodSelector(instance.getPodSelector());
            this.withPolicyTypes(instance.getPolicyTypes());
        }
    }

    @Override
    public A addToEgress(int index, V1NetworkPolicyEgressRule item) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        V1NetworkPolicyEgressRuleBuilder builder = new V1NetworkPolicyEgressRuleBuilder(item);
        if (index < 0 || index >= this.egress.size()) {
            this._visitables.get("egress").add(builder);
            this.egress.add(builder);
        } else {
            this._visitables.get("egress").add(index, builder);
            this.egress.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToEgress(int index, V1NetworkPolicyEgressRule item) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        V1NetworkPolicyEgressRuleBuilder builder = new V1NetworkPolicyEgressRuleBuilder(item);
        if (index < 0 || index >= this.egress.size()) {
            this._visitables.get("egress").add(builder);
            this.egress.add(builder);
        } else {
            this._visitables.get("egress").set(index, builder);
            this.egress.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEgress(V1NetworkPolicyEgressRule ... items) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        for (V1NetworkPolicyEgressRule item : items) {
            V1NetworkPolicyEgressRuleBuilder builder = new V1NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get("egress").add(builder);
            this.egress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEgress(Collection<V1NetworkPolicyEgressRule> items) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        for (V1NetworkPolicyEgressRule item : items) {
            V1NetworkPolicyEgressRuleBuilder builder = new V1NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get("egress").add(builder);
            this.egress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEgress(V1NetworkPolicyEgressRule ... items) {
        for (V1NetworkPolicyEgressRule item : items) {
            V1NetworkPolicyEgressRuleBuilder builder = new V1NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get("egress").remove(builder);
            if (this.egress == null) continue;
            this.egress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEgress(Collection<V1NetworkPolicyEgressRule> items) {
        for (V1NetworkPolicyEgressRule item : items) {
            V1NetworkPolicyEgressRuleBuilder builder = new V1NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get("egress").remove(builder);
            if (this.egress == null) continue;
            this.egress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEgress(Predicate<V1NetworkPolicyEgressRuleBuilder> predicate) {
        if (this.egress == null) {
            return (A)this;
        }
        Iterator<V1NetworkPolicyEgressRuleBuilder> each = this.egress.iterator();
        Object visitables = this._visitables.get("egress");
        while (each.hasNext()) {
            V1NetworkPolicyEgressRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1NetworkPolicyEgressRule> getEgress() {
        return this.egress != null ? V1NetworkPolicySpecFluentImpl.build(this.egress) : null;
    }

    @Override
    public List<V1NetworkPolicyEgressRule> buildEgress() {
        return this.egress != null ? V1NetworkPolicySpecFluentImpl.build(this.egress) : null;
    }

    @Override
    public V1NetworkPolicyEgressRule buildEgress(int index) {
        return this.egress.get(index).build();
    }

    @Override
    public V1NetworkPolicyEgressRule buildFirstEgress() {
        return this.egress.get(0).build();
    }

    @Override
    public V1NetworkPolicyEgressRule buildLastEgress() {
        return this.egress.get(this.egress.size() - 1).build();
    }

    @Override
    public V1NetworkPolicyEgressRule buildMatchingEgress(Predicate<V1NetworkPolicyEgressRuleBuilder> predicate) {
        for (V1NetworkPolicyEgressRuleBuilder item : this.egress) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEgress(Predicate<V1NetworkPolicyEgressRuleBuilder> predicate) {
        for (V1NetworkPolicyEgressRuleBuilder item : this.egress) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEgress(List<V1NetworkPolicyEgressRule> egress) {
        if (this.egress != null) {
            this._visitables.get("egress").clear();
        }
        if (egress != null) {
            this.egress = new ArrayList();
            for (V1NetworkPolicyEgressRule item : egress) {
                this.addToEgress(item);
            }
        } else {
            this.egress = null;
        }
        return (A)this;
    }

    @Override
    public A withEgress(V1NetworkPolicyEgressRule ... egress) {
        if (this.egress != null) {
            this.egress.clear();
            this._visitables.remove("egress");
        }
        if (egress != null) {
            for (V1NetworkPolicyEgressRule item : egress) {
                this.addToEgress(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEgress() {
        return this.egress != null && !this.egress.isEmpty();
    }

    @Override
    public V1NetworkPolicySpecFluent.EgressNested<A> addNewEgress() {
        return new EgressNestedImpl();
    }

    @Override
    public V1NetworkPolicySpecFluent.EgressNested<A> addNewEgressLike(V1NetworkPolicyEgressRule item) {
        return new EgressNestedImpl(-1, item);
    }

    @Override
    public V1NetworkPolicySpecFluent.EgressNested<A> setNewEgressLike(int index, V1NetworkPolicyEgressRule item) {
        return new EgressNestedImpl(index, item);
    }

    @Override
    public V1NetworkPolicySpecFluent.EgressNested<A> editEgress(int index) {
        if (this.egress.size() <= index) {
            throw new RuntimeException("Can't edit egress. Index exceeds size.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    @Override
    public V1NetworkPolicySpecFluent.EgressNested<A> editFirstEgress() {
        if (this.egress.size() == 0) {
            throw new RuntimeException("Can't edit first egress. The list is empty.");
        }
        return this.setNewEgressLike(0, this.buildEgress(0));
    }

    @Override
    public V1NetworkPolicySpecFluent.EgressNested<A> editLastEgress() {
        int index = this.egress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last egress. The list is empty.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    @Override
    public V1NetworkPolicySpecFluent.EgressNested<A> editMatchingEgress(Predicate<V1NetworkPolicyEgressRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.egress.size(); ++i) {
            if (!predicate.test(this.egress.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching egress. No match found.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    @Override
    public A addToIngress(int index, V1NetworkPolicyIngressRule item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        V1NetworkPolicyIngressRuleBuilder builder = new V1NetworkPolicyIngressRuleBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get("ingress").add(index, builder);
            this.ingress.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToIngress(int index, V1NetworkPolicyIngressRule item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        V1NetworkPolicyIngressRuleBuilder builder = new V1NetworkPolicyIngressRuleBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get("ingress").set(index, builder);
            this.ingress.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIngress(V1NetworkPolicyIngressRule ... items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (V1NetworkPolicyIngressRule item : items) {
            V1NetworkPolicyIngressRuleBuilder builder = new V1NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIngress(Collection<V1NetworkPolicyIngressRule> items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (V1NetworkPolicyIngressRule item : items) {
            V1NetworkPolicyIngressRuleBuilder builder = new V1NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIngress(V1NetworkPolicyIngressRule ... items) {
        for (V1NetworkPolicyIngressRule item : items) {
            V1NetworkPolicyIngressRuleBuilder builder = new V1NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get("ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIngress(Collection<V1NetworkPolicyIngressRule> items) {
        for (V1NetworkPolicyIngressRule item : items) {
            V1NetworkPolicyIngressRuleBuilder builder = new V1NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get("ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromIngress(Predicate<V1NetworkPolicyIngressRuleBuilder> predicate) {
        if (this.ingress == null) {
            return (A)this;
        }
        Iterator<V1NetworkPolicyIngressRuleBuilder> each = this.ingress.iterator();
        Object visitables = this._visitables.get("ingress");
        while (each.hasNext()) {
            V1NetworkPolicyIngressRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1NetworkPolicyIngressRule> getIngress() {
        return this.ingress != null ? V1NetworkPolicySpecFluentImpl.build(this.ingress) : null;
    }

    @Override
    public List<V1NetworkPolicyIngressRule> buildIngress() {
        return this.ingress != null ? V1NetworkPolicySpecFluentImpl.build(this.ingress) : null;
    }

    @Override
    public V1NetworkPolicyIngressRule buildIngress(int index) {
        return this.ingress.get(index).build();
    }

    @Override
    public V1NetworkPolicyIngressRule buildFirstIngress() {
        return this.ingress.get(0).build();
    }

    @Override
    public V1NetworkPolicyIngressRule buildLastIngress() {
        return this.ingress.get(this.ingress.size() - 1).build();
    }

    @Override
    public V1NetworkPolicyIngressRule buildMatchingIngress(Predicate<V1NetworkPolicyIngressRuleBuilder> predicate) {
        for (V1NetworkPolicyIngressRuleBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingIngress(Predicate<V1NetworkPolicyIngressRuleBuilder> predicate) {
        for (V1NetworkPolicyIngressRuleBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withIngress(List<V1NetworkPolicyIngressRule> ingress) {
        if (this.ingress != null) {
            this._visitables.get("ingress").clear();
        }
        if (ingress != null) {
            this.ingress = new ArrayList();
            for (V1NetworkPolicyIngressRule item : ingress) {
                this.addToIngress(item);
            }
        } else {
            this.ingress = null;
        }
        return (A)this;
    }

    @Override
    public A withIngress(V1NetworkPolicyIngressRule ... ingress) {
        if (this.ingress != null) {
            this.ingress.clear();
            this._visitables.remove("ingress");
        }
        if (ingress != null) {
            for (V1NetworkPolicyIngressRule item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIngress() {
        return this.ingress != null && !this.ingress.isEmpty();
    }

    @Override
    public V1NetworkPolicySpecFluent.IngressNested<A> addNewIngress() {
        return new IngressNestedImpl();
    }

    @Override
    public V1NetworkPolicySpecFluent.IngressNested<A> addNewIngressLike(V1NetworkPolicyIngressRule item) {
        return new IngressNestedImpl(-1, item);
    }

    @Override
    public V1NetworkPolicySpecFluent.IngressNested<A> setNewIngressLike(int index, V1NetworkPolicyIngressRule item) {
        return new IngressNestedImpl(index, item);
    }

    @Override
    public V1NetworkPolicySpecFluent.IngressNested<A> editIngress(int index) {
        if (this.ingress.size() <= index) {
            throw new RuntimeException("Can't edit ingress. Index exceeds size.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public V1NetworkPolicySpecFluent.IngressNested<A> editFirstIngress() {
        if (this.ingress.size() == 0) {
            throw new RuntimeException("Can't edit first ingress. The list is empty.");
        }
        return this.setNewIngressLike(0, this.buildIngress(0));
    }

    @Override
    public V1NetworkPolicySpecFluent.IngressNested<A> editLastIngress() {
        int index = this.ingress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ingress. The list is empty.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public V1NetworkPolicySpecFluent.IngressNested<A> editMatchingIngress(Predicate<V1NetworkPolicyIngressRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ingress.size(); ++i) {
            if (!predicate.test(this.ingress.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ingress. No match found.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    @Deprecated
    public V1LabelSelector getPodSelector() {
        return this.podSelector != null ? this.podSelector.build() : null;
    }

    @Override
    public V1LabelSelector buildPodSelector() {
        return this.podSelector != null ? this.podSelector.build() : null;
    }

    @Override
    public A withPodSelector(V1LabelSelector podSelector) {
        this._visitables.get("podSelector").remove(this.podSelector);
        if (podSelector != null) {
            this.podSelector = new V1LabelSelectorBuilder(podSelector);
            this._visitables.get("podSelector").add(this.podSelector);
        } else {
            this.podSelector = null;
            this._visitables.get("podSelector").remove(this.podSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPodSelector() {
        return this.podSelector != null;
    }

    @Override
    public V1NetworkPolicySpecFluent.PodSelectorNested<A> withNewPodSelector() {
        return new PodSelectorNestedImpl();
    }

    @Override
    public V1NetworkPolicySpecFluent.PodSelectorNested<A> withNewPodSelectorLike(V1LabelSelector item) {
        return new PodSelectorNestedImpl(item);
    }

    @Override
    public V1NetworkPolicySpecFluent.PodSelectorNested<A> editPodSelector() {
        return this.withNewPodSelectorLike(this.getPodSelector());
    }

    @Override
    public V1NetworkPolicySpecFluent.PodSelectorNested<A> editOrNewPodSelector() {
        return this.withNewPodSelectorLike(this.getPodSelector() != null ? this.getPodSelector() : new V1LabelSelectorBuilder().build());
    }

    @Override
    public V1NetworkPolicySpecFluent.PodSelectorNested<A> editOrNewPodSelectorLike(V1LabelSelector item) {
        return this.withNewPodSelectorLike(this.getPodSelector() != null ? this.getPodSelector() : item);
    }

    @Override
    public A addToPolicyTypes(int index, String item) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        this.policyTypes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPolicyTypes(int index, String item) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        this.policyTypes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPolicyTypes(String ... items) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.policyTypes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPolicyTypes(Collection<String> items) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.policyTypes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPolicyTypes(String ... items) {
        for (String item : items) {
            if (this.policyTypes == null) continue;
            this.policyTypes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPolicyTypes(Collection<String> items) {
        for (String item : items) {
            if (this.policyTypes == null) continue;
            this.policyTypes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPolicyTypes() {
        return this.policyTypes;
    }

    @Override
    public String getPolicyType(int index) {
        return this.policyTypes.get(index);
    }

    @Override
    public String getFirstPolicyType() {
        return this.policyTypes.get(0);
    }

    @Override
    public String getLastPolicyType() {
        return this.policyTypes.get(this.policyTypes.size() - 1);
    }

    @Override
    public String getMatchingPolicyType(Predicate<String> predicate) {
        for (String item : this.policyTypes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPolicyType(Predicate<String> predicate) {
        for (String item : this.policyTypes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPolicyTypes(List<String> policyTypes) {
        if (policyTypes != null) {
            this.policyTypes = new ArrayList<String>();
            for (String item : policyTypes) {
                this.addToPolicyTypes(item);
            }
        } else {
            this.policyTypes = null;
        }
        return (A)this;
    }

    @Override
    public A withPolicyTypes(String ... policyTypes) {
        if (this.policyTypes != null) {
            this.policyTypes.clear();
            this._visitables.remove("policyTypes");
        }
        if (policyTypes != null) {
            for (String item : policyTypes) {
                this.addToPolicyTypes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPolicyTypes() {
        return this.policyTypes != null && !this.policyTypes.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1NetworkPolicySpecFluentImpl that = (V1NetworkPolicySpecFluentImpl)o;
        if (!Objects.equals(this.egress, that.egress)) {
            return false;
        }
        if (!Objects.equals(this.ingress, that.ingress)) {
            return false;
        }
        if (!Objects.equals(this.podSelector, that.podSelector)) {
            return false;
        }
        return Objects.equals(this.policyTypes, that.policyTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.egress, this.ingress, this.podSelector, this.policyTypes, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.egress != null) {
            sb.append("egress:");
            sb.append(this.egress + ",");
        }
        if (this.ingress != null) {
            sb.append("ingress:");
            sb.append(this.ingress + ",");
        }
        if (this.podSelector != null) {
            sb.append("podSelector:");
            sb.append(this.podSelector + ",");
        }
        if (this.policyTypes != null && !this.policyTypes.isEmpty()) {
            sb.append("policyTypes:");
            sb.append(this.policyTypes);
        }
        sb.append("}");
        return sb.toString();
    }

    class EgressNestedImpl<N>
    extends V1NetworkPolicyEgressRuleFluentImpl<V1NetworkPolicySpecFluent.EgressNested<N>>
    implements V1NetworkPolicySpecFluent.EgressNested<N>,
    Nested<N> {
        V1NetworkPolicyEgressRuleBuilder builder;
        int index;

        EgressNestedImpl(int index, V1NetworkPolicyEgressRule item) {
            this.index = index;
            this.builder = new V1NetworkPolicyEgressRuleBuilder(this, item);
        }

        EgressNestedImpl() {
            this.index = -1;
            this.builder = new V1NetworkPolicyEgressRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1NetworkPolicySpecFluentImpl.this.setToEgress(this.index, this.builder.build());
        }

        @Override
        public N endEgress() {
            return this.and();
        }
    }

    class IngressNestedImpl<N>
    extends V1NetworkPolicyIngressRuleFluentImpl<V1NetworkPolicySpecFluent.IngressNested<N>>
    implements V1NetworkPolicySpecFluent.IngressNested<N>,
    Nested<N> {
        V1NetworkPolicyIngressRuleBuilder builder;
        int index;

        IngressNestedImpl(int index, V1NetworkPolicyIngressRule item) {
            this.index = index;
            this.builder = new V1NetworkPolicyIngressRuleBuilder(this, item);
        }

        IngressNestedImpl() {
            this.index = -1;
            this.builder = new V1NetworkPolicyIngressRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1NetworkPolicySpecFluentImpl.this.setToIngress(this.index, this.builder.build());
        }

        @Override
        public N endIngress() {
            return this.and();
        }
    }

    class PodSelectorNestedImpl<N>
    extends V1LabelSelectorFluentImpl<V1NetworkPolicySpecFluent.PodSelectorNested<N>>
    implements V1NetworkPolicySpecFluent.PodSelectorNested<N>,
    Nested<N> {
        V1LabelSelectorBuilder builder;

        PodSelectorNestedImpl(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        PodSelectorNestedImpl() {
            this.builder = new V1LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1NetworkPolicySpecFluentImpl.this.withPodSelector(this.builder.build());
        }

        @Override
        public N endPodSelector() {
            return this.and();
        }
    }
}

