/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V2MetricTarget;
import io.kubernetes.client.openapi.models.V2MetricTargetBuilder;
import io.kubernetes.client.openapi.models.V2MetricTargetFluentImpl;
import io.kubernetes.client.openapi.models.V2ResourceMetricSource;
import io.kubernetes.client.openapi.models.V2ResourceMetricSourceFluent;
import java.util.Objects;

public class V2ResourceMetricSourceFluentImpl<A extends V2ResourceMetricSourceFluent<A>>
extends BaseFluent<A>
implements V2ResourceMetricSourceFluent<A> {
    private String name;
    private V2MetricTargetBuilder target;

    public V2ResourceMetricSourceFluentImpl() {
    }

    public V2ResourceMetricSourceFluentImpl(V2ResourceMetricSource instance) {
        if (instance != null) {
            this.withName(instance.getName());
            this.withTarget(instance.getTarget());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public V2MetricTarget getTarget() {
        return this.target != null ? this.target.build() : null;
    }

    @Override
    public V2MetricTarget buildTarget() {
        return this.target != null ? this.target.build() : null;
    }

    @Override
    public A withTarget(V2MetricTarget target) {
        this._visitables.get("target").remove(this.target);
        if (target != null) {
            this.target = new V2MetricTargetBuilder(target);
            this._visitables.get("target").add(this.target);
        } else {
            this.target = null;
            this._visitables.get("target").remove(this.target);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTarget() {
        return this.target != null;
    }

    @Override
    public V2ResourceMetricSourceFluent.TargetNested<A> withNewTarget() {
        return new TargetNestedImpl();
    }

    @Override
    public V2ResourceMetricSourceFluent.TargetNested<A> withNewTargetLike(V2MetricTarget item) {
        return new TargetNestedImpl(item);
    }

    @Override
    public V2ResourceMetricSourceFluent.TargetNested<A> editTarget() {
        return this.withNewTargetLike(this.getTarget());
    }

    @Override
    public V2ResourceMetricSourceFluent.TargetNested<A> editOrNewTarget() {
        return this.withNewTargetLike(this.getTarget() != null ? this.getTarget() : new V2MetricTargetBuilder().build());
    }

    @Override
    public V2ResourceMetricSourceFluent.TargetNested<A> editOrNewTargetLike(V2MetricTarget item) {
        return this.withNewTargetLike(this.getTarget() != null ? this.getTarget() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V2ResourceMetricSourceFluentImpl that = (V2ResourceMetricSourceFluentImpl)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.target, that.target);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.target, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.target != null) {
            sb.append("target:");
            sb.append(this.target);
        }
        sb.append("}");
        return sb.toString();
    }

    class TargetNestedImpl<N>
    extends V2MetricTargetFluentImpl<V2ResourceMetricSourceFluent.TargetNested<N>>
    implements V2ResourceMetricSourceFluent.TargetNested<N>,
    Nested<N> {
        V2MetricTargetBuilder builder;

        TargetNestedImpl(V2MetricTarget item) {
            this.builder = new V2MetricTargetBuilder(this, item);
        }

        TargetNestedImpl() {
            this.builder = new V2MetricTargetBuilder(this);
        }

        @Override
        public N and() {
            return (N)V2ResourceMetricSourceFluentImpl.this.withTarget(this.builder.build());
        }

        @Override
        public N endTarget() {
            return this.and();
        }
    }
}

