/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.input;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class DruidSegmentInputEntity
implements InputEntity {
    private static final EmittingLogger log = new EmittingLogger(DruidSegmentInputEntity.class);
    private final SegmentCacheManager segmentCacheManager;
    private final DataSegment segment;
    private final Interval intervalFilter;

    DruidSegmentInputEntity(SegmentCacheManager segmentCacheManager, DataSegment segment, Interval intervalFilter) {
        this.segmentCacheManager = segmentCacheManager;
        this.segment = segment;
        this.intervalFilter = intervalFilter;
    }

    Interval getIntervalFilter() {
        return this.intervalFilter;
    }

    @Nullable
    public URI getUri() {
        return null;
    }

    public InputStream open() {
        throw new UnsupportedOperationException("Don't call this");
    }

    public InputEntity.CleanableFile fetch(File temporaryDirectory, byte[] fetchBuffer) {
        File segmentFile;
        try {
            this.segmentCacheManager.load(this.segment);
            segmentFile = this.segmentCacheManager.getSegmentFiles(this.segment);
        }
        catch (SegmentLoadingException e) {
            throw new RuntimeException(e);
        }
        return new InputEntity.CleanableFile(){

            public File file() {
                return segmentFile;
            }

            public void close() {
                DruidSegmentInputEntity.this.segmentCacheManager.drop(DruidSegmentInputEntity.this.segment);
            }
        };
    }

    public boolean isFromTombstone() {
        return this.segment.isTombstone();
    }
}

