/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.autoscaling;

import java.util.List;
import org.apache.druid.indexing.overlord.autoscaling.AutoScaler;
import org.apache.druid.indexing.overlord.autoscaling.AutoScalingData;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.emitter.EmittingLogger;

public class NoopAutoScaler<Void>
implements AutoScaler<Void> {
    private static final EmittingLogger log = new EmittingLogger(NoopAutoScaler.class);

    @Override
    public int getMinNumWorkers() {
        return 0;
    }

    @Override
    public int getMaxNumWorkers() {
        return 0;
    }

    @Override
    public Void getEnvConfig() {
        throw new UOE("No config for Noop!", new Object[0]);
    }

    @Override
    public AutoScalingData provision() {
        log.info("If I were a real strategy I'd create something now", new Object[0]);
        return null;
    }

    @Override
    public AutoScalingData terminate(List<String> ips) {
        log.info("If I were a real strategy I'd terminate %s now", new Object[]{ips});
        return null;
    }

    @Override
    public AutoScalingData terminateWithIds(List<String> ids) {
        log.info("If I were a real strategy I'd terminate %s now", new Object[]{ids});
        return null;
    }

    @Override
    public List<String> ipToIdLookup(List<String> ips) {
        log.info("I'm not a real strategy so I'm returning what I got %s", new Object[]{ips});
        return ips;
    }

    @Override
    public List<String> idToIpLookup(List<String> nodeIds) {
        log.info("I'm not a real strategy so I'm returning what I got %s", new Object[]{nodeIds});
        return nodeIds;
    }
}

