/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.sampler;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.SamplerResponse;
import org.apache.druid.client.indexing.SamplerSpec;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.indexing.common.task.IndexTask;
import org.apache.druid.indexing.overlord.sampler.InputSourceSampler;
import org.apache.druid.indexing.overlord.sampler.SamplerConfig;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.ResourceAction;

public class IndexTaskSamplerSpec
implements SamplerSpec {
    @Nullable
    private final DataSchema dataSchema;
    private final InputSource inputSource;
    @Nullable
    private final InputFormat inputFormat;
    @Nullable
    private final SamplerConfig samplerConfig;
    private final InputSourceSampler inputSourceSampler;

    @JsonCreator
    public IndexTaskSamplerSpec(@JsonProperty(value="spec") IndexTask.IndexIngestionSpec ingestionSpec, @JsonProperty(value="samplerConfig") @Nullable SamplerConfig samplerConfig, @JacksonInject InputSourceSampler inputSourceSampler) {
        this.dataSchema = ((IndexTask.IndexIngestionSpec)((Object)Preconditions.checkNotNull((Object)((Object)ingestionSpec), (Object)"[spec] is required"))).getDataSchema();
        Preconditions.checkNotNull((Object)ingestionSpec.getIOConfig(), (Object)"[spec.ioConfig] is required");
        this.inputSource = (InputSource)Preconditions.checkNotNull((Object)ingestionSpec.getIOConfig().getInputSource(), (Object)"[spec.ioConfig.inputSource] is required");
        this.inputFormat = this.inputSource.needsFormat() ? (InputFormat)Preconditions.checkNotNull((Object)ingestionSpec.getIOConfig().getInputFormat(), (Object)"[spec.ioConfig.inputFormat] is required") : null;
        this.samplerConfig = samplerConfig;
        this.inputSourceSampler = inputSourceSampler;
    }

    public SamplerResponse sample() {
        return this.inputSourceSampler.sample(this.inputSource, this.inputFormat, this.dataSchema, this.samplerConfig);
    }

    public String getType() {
        return "index";
    }

    @JsonIgnore
    @Nonnull
    public Set<ResourceAction> getInputSourceResources() throws UOE {
        return this.inputSource.getTypes().stream().map(AuthorizationUtils::createExternalResourceReadAction).collect(Collectors.toSet());
    }
}

