/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.google;

import com.google.api.client.http.HttpResponseException;
import com.google.cloud.storage.StorageException;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.google.GoogleInputDataConfig;
import org.apache.druid.storage.google.GoogleStorage;
import org.apache.druid.storage.google.GoogleStorageObjectMetadata;
import org.apache.druid.storage.google.ObjectStorageIterator;

public class GoogleUtils {
    private static final Logger log = new Logger(GoogleUtils.class);
    public static final Predicate<Throwable> GOOGLE_RETRY = GoogleUtils::isRetryable;

    public static boolean isRetryable(Throwable t) {
        if (t instanceof HttpResponseException) {
            HttpResponseException e = (HttpResponseException)t;
            return e.getStatusCode() == 429 || e.getStatusCode() / 500 == 1;
        }
        if (t instanceof StorageException) {
            StorageException e = (StorageException)t;
            return e.isRetryable();
        }
        return t instanceof IOException;
    }

    public static <T> T retryGoogleCloudStorageOperation(RetryUtils.Task<T> f) throws Exception {
        return (T)RetryUtils.retry(f, GOOGLE_RETRY, (int)10);
    }

    public static URI objectToUri(GoogleStorageObjectMetadata object) {
        return GoogleUtils.objectToCloudObjectLocation(object).toUri("gs");
    }

    public static CloudObjectLocation objectToCloudObjectLocation(GoogleStorageObjectMetadata object) {
        return new CloudObjectLocation(object.getBucket(), object.getName());
    }

    public static Iterator<GoogleStorageObjectMetadata> lazyFetchingStorageObjectsIterator(GoogleStorage storage, Iterator<URI> uris, long maxListingLength) {
        return new ObjectStorageIterator(storage, uris, maxListingLength);
    }

    public static void deleteObjectsInPath(GoogleStorage storage, GoogleInputDataConfig config, String bucket, String prefix, Predicate<GoogleStorageObjectMetadata> filter) throws Exception {
        Iterator<GoogleStorageObjectMetadata> iterator = GoogleUtils.lazyFetchingStorageObjectsIterator(storage, (Iterator<URI>)ImmutableList.of((Object)new CloudObjectLocation(bucket, prefix).toUri("gs")).iterator(), config.getMaxListingLength());
        while (iterator.hasNext()) {
            GoogleStorageObjectMetadata nextObject = iterator.next();
            if (!filter.apply((Object)nextObject)) continue;
            GoogleUtils.retryGoogleCloudStorageOperation(() -> {
                storage.delete(nextObject.getBucket(), nextObject.getName());
                return null;
            });
        }
    }

    public static boolean isDirectoryPlaceholder(GoogleStorageObjectMetadata objectMetadata) {
        if (objectMetadata.getName().endsWith("/") && objectMetadata.getSize().intValue() == 0) {
            return true;
        }
        return objectMetadata.getName().endsWith("_$folder$") && objectMetadata.getSize().intValue() == 0;
    }
}

