/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.messages.server;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.messages.MessageBatch;
import org.apache.druid.messages.server.Outbox;

public class MessageRelayResource<MessageType> {
    private static final Logger log = new Logger(MessageRelayResource.class);
    private static final long GET_MESSAGES_TIMEOUT = 30000L;
    private final Outbox<MessageType> outbox;
    private final ObjectMapper smileMapper;
    private final JavaType batchType;

    public MessageRelayResource(Outbox<MessageType> outbox, ObjectMapper smileMapper, Class<MessageType> messageClass) {
        this.outbox = outbox;
        this.smileMapper = smileMapper;
        this.batchType = smileMapper.getTypeFactory().constructParametricType(MessageBatch.class, new Class[]{messageClass});
    }

    @GET
    @Path(value="/outbox/{clientHost}/messages")
    public Void httpGetMessagesFromOutbox(@PathParam(value="clientHost") String clientHost, @QueryParam(value="epoch") Long epoch, @QueryParam(value="watermark") Long watermark, @Context HttpServletRequest req) throws IOException {
        if (epoch == null || watermark == null || clientHost == null || clientHost.isEmpty()) {
            AsyncContext asyncContext = req.startAsync();
            HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
            response.sendError(400);
            asyncContext.complete();
            return null;
        }
        final AtomicBoolean didRespond = new AtomicBoolean();
        final ListenableFuture<MessageBatch<MessageType>> batchFuture = this.outbox.getMessages(clientHost, epoch, watermark);
        final AsyncContext asyncContext = req.startAsync();
        asyncContext.setTimeout(30000L);
        asyncContext.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent event) {
            }

            public void onTimeout(AsyncEvent event) {
                if (didRespond.compareAndSet(false, true)) {
                    HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
                    response.setStatus(204);
                    event.getAsyncContext().complete();
                    batchFuture.cancel(true);
                }
            }

            public void onError(AsyncEvent event) {
            }

            public void onStartAsync(AsyncEvent event) {
            }
        });
        final String remoteAddr = req.getRemoteAddr();
        final String requestURI = req.getRequestURI();
        Futures.addCallback(batchFuture, (FutureCallback)new FutureCallback<MessageBatch<MessageType>>(){

            public void onSuccess(MessageBatch<MessageType> result) {
                if (didRespond.compareAndSet(false, true)) {
                    log.debug("Sending message batch: %s", new Object[]{result});
                    try {
                        HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
                        response.setStatus(200);
                        response.setContentType("application/x-jackson-smile");
                        MessageRelayResource.this.smileMapper.writerFor(MessageRelayResource.this.batchType).writeValue((OutputStream)asyncContext.getResponse().getOutputStream(), result);
                        response.getOutputStream().close();
                        asyncContext.complete();
                    }
                    catch (Exception e) {
                        log.noStackTrace().warn((Throwable)e, "Could not respond to request from[%s] to[%s]", new Object[]{remoteAddr, requestURI});
                    }
                }
            }

            public void onFailure(Throwable e) {
                if (didRespond.compareAndSet(false, true)) {
                    try {
                        HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
                        response.sendError(500);
                        asyncContext.complete();
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                    }
                    log.noStackTrace().warn(e, "Request failed from[%s] to[%s]", new Object[]{remoteAddr, requestURI});
                }
            }
        }, (Executor)Execs.directExecutor());
        return null;
    }
}

