/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.sink;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentMapFunction;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexAddResult;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.realtime.FireHydrant;
import org.apache.druid.segment.realtime.sink.SinkSegmentReference;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.Overshadowable;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.utils.CloseableUtils;
import org.joda.time.Interval;

public class Sink
implements Iterable<FireHydrant>,
Overshadowable<Sink> {
    private static final IncrementalIndexAddResult NOT_WRITABLE = new IncrementalIndexAddResult(-1, -1L, "not writable");
    private static final IncrementalIndexAddResult ALREADY_SWAPPED = new IncrementalIndexAddResult(-1, -1L, "write after index swapped");
    private static final Logger log = new Logger(Sink.class);
    private final Object hydrantLock = new Object();
    private final Interval interval;
    private final DataSchema schema;
    private final ShardSpec shardSpec;
    private final String version;
    private final AppendableIndexSpec appendableIndexSpec;
    private final int maxRowsInMemory;
    private final long maxBytesInMemory;
    private final CopyOnWriteArrayList<FireHydrant> hydrants = new CopyOnWriteArrayList();
    private final LinkedHashSet<String> dimOrder = new LinkedHashSet();
    @GuardedBy(value="hydrantLock")
    private final LinkedHashSet<String> columnsExcludingCurrIndex = new LinkedHashSet();
    private final Map<String, ColumnType> columnTypeExcludingCurrIndex = new HashMap<String, ColumnType>();
    private final AtomicInteger numRowsExcludingCurrIndex = new AtomicInteger();
    private volatile FireHydrant currHydrant;
    private volatile boolean writable = true;

    public Sink(Interval interval, DataSchema schema, ShardSpec shardSpec, String version, AppendableIndexSpec appendableIndexSpec, int maxRowsInMemory, long maxBytesInMemory) {
        this(interval, schema, shardSpec, version, appendableIndexSpec, maxRowsInMemory, maxBytesInMemory, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sink(Interval interval, DataSchema schema, ShardSpec shardSpec, String version, AppendableIndexSpec appendableIndexSpec, int maxRowsInMemory, long maxBytesInMemory, List<FireHydrant> hydrants) {
        this.schema = schema;
        this.shardSpec = shardSpec;
        this.interval = interval;
        this.version = version;
        this.appendableIndexSpec = appendableIndexSpec;
        this.maxRowsInMemory = maxRowsInMemory;
        this.maxBytesInMemory = maxBytesInMemory;
        int maxCount = -1;
        for (int i = 0; i < hydrants.size(); ++i) {
            FireHydrant hydrant = hydrants.get(i);
            if (hydrant.getCount() <= maxCount) {
                throw new ISE("hydrant[%s] not the right count[%s]", new Object[]{hydrant, i});
            }
            maxCount = hydrant.getCount();
            Segment segment = hydrant.acquireSegment();
            try {
                this.overwriteIndexDimensions(segment);
                QueryableIndex index = (QueryableIndex)segment.as(QueryableIndex.class);
                this.numRowsExcludingCurrIndex.addAndGet(index.getNumRows());
                continue;
            }
            finally {
                CloseableUtils.closeAndWrapExceptions((Closeable)segment);
            }
        }
        this.hydrants.addAll(hydrants);
        this.makeNewCurrIndex(interval.getStartMillis(), schema);
    }

    public Interval getInterval() {
        return this.interval;
    }

    public FireHydrant getCurrHydrant() {
        return this.currHydrant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrementalIndexAddResult add(InputRow row) {
        if (this.currHydrant == null) {
            throw new IAE("No currHydrant but given row[%s]", new Object[]{row});
        }
        Object object = this.hydrantLock;
        synchronized (object) {
            if (!this.writable) {
                return NOT_WRITABLE;
            }
            IncrementalIndex index = this.currHydrant.getIndex();
            if (index == null) {
                return ALREADY_SWAPPED;
            }
            return index.add(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAppendRow() {
        Object object = this.hydrantLock;
        synchronized (object) {
            return this.writable && this.currHydrant != null && this.currHydrant.getIndex().canAppendRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.hydrantLock;
        synchronized (object) {
            return this.hydrants.size() == 1 && this.currHydrant.getIndex().isEmpty();
        }
    }

    public boolean isWritable() {
        return this.writable;
    }

    public FireHydrant swap() {
        return this.makeNewCurrIndex(this.interval.getStartMillis(), this.schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean swappable() {
        Object object = this.hydrantLock;
        synchronized (object) {
            return this.writable && this.currHydrant.getIndex() != null && this.currHydrant.getIndex().numRows() != 0;
        }
    }

    public boolean finished() {
        return !this.writable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finishWriting() {
        Object object = this.hydrantLock;
        synchronized (object) {
            if (!this.writable) {
                return false;
            }
            this.writable = false;
        }
        return true;
    }

    public DataSegment getSegment() {
        return DataSegment.builder((SegmentId)SegmentId.of((String)this.schema.getDataSource(), (Interval)this.interval, (String)this.version, (ShardSpec)this.shardSpec)).shardSpec(this.shardSpec).dimensions(null).metrics(Lists.transform(Arrays.asList(this.schema.getAggregators()), AggregatorFactory::getName)).projections(this.schema.getProjectionNames()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumRows() {
        Object object = this.hydrantLock;
        synchronized (object) {
            return this.numRowsExcludingCurrIndex.get() + this.getNumRowsInMemory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumRowsInMemory() {
        Object object = this.hydrantLock;
        synchronized (object) {
            IncrementalIndex index = this.currHydrant.getIndex();
            if (index == null) {
                return 0;
            }
            return index.numRows();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesInMemory() {
        Object object = this.hydrantLock;
        synchronized (object) {
            IncrementalIndex index = this.currHydrant.getIndex();
            if (index == null) {
                return 0L;
            }
            return index.getBytesInMemory().get();
        }
    }

    @Nullable
    public List<SinkSegmentReference> acquireSegmentReferences(SegmentMapFunction segmentMapFn, boolean skipIncrementalSegment) {
        return Sink.acquireSegmentReferences(this.hydrants, segmentMapFn, skipIncrementalSegment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private FireHydrant makeNewCurrIndex(long minTimestamp, DataSchema schema) {
        indexSchema = new IncrementalIndexSchema.Builder().withMinTimestamp(minTimestamp).withTimestampSpec(schema.getTimestampSpec()).withQueryGranularity(schema.getGranularitySpec().getQueryGranularity()).withDimensionsSpec(schema.getDimensionsSpec()).withMetrics(schema.getAggregators()).withRollup(schema.getGranularitySpec().isRollup()).withProjections(schema.getProjections()).build();
        newIndex = this.appendableIndexSpec.builder().setIndexSchema(indexSchema).setMaxRowCount(this.maxRowsInMemory).setMaxBytesInMemory(this.maxBytesInMemory).build();
        var7_5 = this.hydrantLock;
        synchronized (var7_5) {
            if (this.writable) {
                old = this.currHydrant;
                newCount = 0;
                numHydrants = this.hydrants.size();
                if (numHydrants > 0) {
                    lastHydrant = this.hydrants.get(numHydrants - 1);
                    oldFormat = null;
                    newCount = lastHydrant.getCount() + 1;
                    v0 = variableDimensions = indexSchema.getDimensionsSpec().hasFixedDimensions() == false;
                    if (lastHydrant.hasSwapped()) {
                        oldFormat = new HashMap<K, V>();
                        segment = lastHydrant.acquireSegment();
                        try {
                            this.overwriteIndexDimensions(segment);
                            if (!variableDimensions) ** GOTO lbl44
                            oldIndex = (QueryableIndex)Preconditions.checkNotNull((Object)((QueryableIndex)segment.as(QueryableIndex.class)));
                            for (String dim : oldIndex.getAvailableDimensions()) {
                                this.dimOrder.add(dim);
                                oldFormat.put(dim, oldIndex.getColumnHolder(dim).getColumnFormat());
                            }
                        }
                        finally {
                            CloseableUtils.closeAndWrapExceptions((Closeable)segment);
                        }
                    } else {
                        segment = lastHydrant.acquireSegment();
                        try {
                            this.overwriteIndexDimensions(segment);
                            if (variableDimensions) {
                                oldIndex = lastHydrant.getIndex();
                                this.dimOrder.addAll(oldIndex.getDimensionOrder());
                                oldFormat = oldIndex.getColumnFormats();
                            }
                        }
                        finally {
                            CloseableUtils.closeAndWrapExceptions((Closeable)segment);
                        }
                    }
                    if (variableDimensions) {
                        newIndex.loadDimensionIterable(this.dimOrder, oldFormat);
                    }
                }
                this.currHydrant = new FireHydrant(newIndex, newCount, this.getSegment().getId());
                if (old != null) {
                    this.numRowsExcludingCurrIndex.addAndGet(old.getIndex().numRows());
                }
            } else {
                newIndex.close();
                throw new ISE("finishWriting() called during swap", new Object[0]);
            }
            this.hydrants.add(this.currHydrant);
        }
        return old;
    }

    @GuardedBy(value="hydrantLock")
    private void overwriteIndexDimensions(Segment segment) {
        RowSignature rowSignature = Objects.requireNonNull((CursorFactory)segment.as(CursorFactory.class)).getRowSignature();
        for (String dim : rowSignature.getColumnNames()) {
            this.columnsExcludingCurrIndex.add(dim);
            rowSignature.getColumnType(dim).ifPresent(type -> this.columnTypeExcludingCurrIndex.put(dim, (ColumnType)type));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSignature getSignature() {
        Object object = this.hydrantLock;
        synchronized (object) {
            RowSignature.Builder builder = RowSignature.builder();
            for (String string : this.columnsExcludingCurrIndex) {
                builder.add(string, this.columnTypeExcludingCurrIndex.get(string));
            }
            RowSignature currSignature = ((CursorFactory)this.currHydrant.getHydrantSegment().getBaseSegment().as(CursorFactory.class)).getRowSignature();
            for (String dim : currSignature.getColumnNames()) {
                if (this.columnsExcludingCurrIndex.contains(dim)) continue;
                builder.add(dim, (ColumnType)currSignature.getColumnType(dim).orElse(null));
            }
            RowSignature rowSignature = builder.build();
            log.debug("Sink signature is [%s].", new Object[]{rowSignature});
            return rowSignature;
        }
    }

    @Override
    public Iterator<FireHydrant> iterator() {
        return Iterators.filter(this.hydrants.iterator(), (Predicate)new Predicate<FireHydrant>(){

            public boolean apply(FireHydrant input) {
                IncrementalIndex index = input.getIndex();
                return index == null || index.numRows() != 0;
            }
        });
    }

    public String toString() {
        return "Sink{interval=" + String.valueOf(this.interval) + ", schema=" + String.valueOf(this.schema) + "}";
    }

    public boolean overshadows(Sink other) {
        return false;
    }

    public int getStartRootPartitionId() {
        return this.shardSpec.getStartRootPartitionId();
    }

    public int getEndRootPartitionId() {
        return this.shardSpec.getEndRootPartitionId();
    }

    public String getVersion() {
        return this.version;
    }

    public short getMinorVersion() {
        return this.shardSpec.getMinorVersion();
    }

    public short getAtomicUpdateGroupSize() {
        return this.shardSpec.getAtomicUpdateGroupSize();
    }

    @VisibleForTesting
    static List<SinkSegmentReference> acquireSegmentReferences(List<FireHydrant> hydrants, SegmentMapFunction segmentMapFn, boolean skipIncrementalSegment) {
        ArrayList<SinkSegmentReference> retVal = new ArrayList<SinkSegmentReference>(hydrants.size());
        try {
            for (FireHydrant hydrant : hydrants) {
                boolean hydrantDefinitelySwapped = hydrant.hasSwapped();
                if (skipIncrementalSegment && !hydrantDefinitelySwapped) continue;
                Optional<Segment> maybeHolder = hydrant.getSegmentForQuery(segmentMapFn);
                if (maybeHolder.isPresent()) {
                    Segment holder = maybeHolder.get();
                    retVal.add(new SinkSegmentReference(hydrant.getCount(), holder, hydrantDefinitelySwapped));
                    continue;
                }
                for (SinkSegmentReference reference : retVal) {
                    reference.close();
                }
                return null;
            }
            return retVal;
        }
        catch (Throwable e) {
            for (SinkSegmentReference reference : retVal) {
                CloseableUtils.closeAndSuppressExceptions((Closeable)reference, e::addSuppressed);
            }
            throw e;
        }
    }
}

