/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.audit;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.druid.common.config.Configs;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.HumanReadableBytesRange;
import org.apache.druid.server.audit.AuditLogger;
import org.apache.druid.server.audit.AuditManagerConfig;

public class LoggingAuditManagerConfig
implements AuditManagerConfig {
    @JsonProperty
    private final AuditLogger.Level logLevel;
    @JsonProperty
    @HumanReadableBytesRange(min=-1L, message="maxPayloadSizeBytes must either be -1 (for disabling the check) or a non negative number")
    private final HumanReadableBytes maxPayloadSizeBytes;
    @JsonProperty
    private final boolean skipNullField;
    @JsonProperty
    private final boolean auditSystemRequests;

    @JsonCreator
    public LoggingAuditManagerConfig(@JsonProperty(value="logLevel") AuditLogger.Level logLevel, @JsonProperty(value="auditSystemRequests") Boolean auditSystemRequests, @JsonProperty(value="maxPayloadSizeBytes") HumanReadableBytes maxPayloadSizeBytes, @JsonProperty(value="skipNullField") Boolean skipNullField) {
        this.logLevel = (AuditLogger.Level)((Object)Configs.valueOrDefault((Object)((Object)logLevel), (Object)((Object)AuditLogger.Level.INFO)));
        this.auditSystemRequests = Configs.valueOrDefault((Boolean)auditSystemRequests, (boolean)true);
        this.maxPayloadSizeBytes = (HumanReadableBytes)Configs.valueOrDefault((Object)maxPayloadSizeBytes, (Object)HumanReadableBytes.valueOf((int)-1));
        this.skipNullField = Configs.valueOrDefault((Boolean)skipNullField, (boolean)false);
    }

    @Override
    public boolean isSkipNullField() {
        return this.skipNullField;
    }

    @Override
    public long getMaxPayloadSizeBytes() {
        return this.maxPayloadSizeBytes.getBytes();
    }

    @Override
    public boolean isAuditSystemRequests() {
        return this.auditSystemRequests;
    }

    public AuditLogger.Level getLogLevel() {
        return this.logLevel;
    }
}

