/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.server.coordinator.ClusterCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.joda.time.DateTime;

public class DataSourceCompactionConfigAuditEntry {
    private final ClusterCompactionConfig globalConfig;
    private final DataSourceCompactionConfig compactionConfig;
    private final AuditInfo auditInfo;
    private final DateTime auditTime;

    @JsonCreator
    public DataSourceCompactionConfigAuditEntry(@JsonProperty(value="globalConfig") ClusterCompactionConfig globalConfig, @JsonProperty(value="compactionConfig") DataSourceCompactionConfig compactionConfig, @JsonProperty(value="auditInfo") AuditInfo auditInfo, @JsonProperty(value="auditTime") DateTime auditTime) {
        this.globalConfig = globalConfig;
        this.compactionConfig = compactionConfig;
        this.auditInfo = auditInfo;
        this.auditTime = auditTime;
    }

    @JsonProperty
    public ClusterCompactionConfig getGlobalConfig() {
        return this.globalConfig;
    }

    @JsonProperty
    public DataSourceCompactionConfig getCompactionConfig() {
        return this.compactionConfig;
    }

    @JsonProperty
    public AuditInfo getAuditInfo() {
        return this.auditInfo;
    }

    @JsonProperty
    public DateTime getAuditTime() {
        return this.auditTime;
    }

    public boolean hasSameConfig(DataSourceCompactionConfigAuditEntry other) {
        return Objects.equals(this.compactionConfig, other.compactionConfig) && Objects.equals(this.globalConfig, other.globalConfig);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceCompactionConfigAuditEntry that = (DataSourceCompactionConfigAuditEntry)o;
        return Objects.equals(this.globalConfig, that.globalConfig) && Objects.equals(this.compactionConfig, that.compactionConfig) && Objects.equals(this.auditInfo, that.auditInfo) && Objects.equals(this.auditTime, that.auditTime);
    }

    public int hashCode() {
        return Objects.hash(this.globalConfig, this.compactionConfig, this.auditInfo, this.auditTime);
    }
}

