/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import java.util.List;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.metadata.SegmentSchemaManager;
import org.apache.druid.server.coordinator.config.MetadataCleanupConfig;
import org.apache.druid.server.coordinator.duty.MetadataCleanupDuty;
import org.apache.druid.server.coordinator.stats.Stats;
import org.joda.time.DateTime;

public class KillUnreferencedSegmentSchema
extends MetadataCleanupDuty {
    private static final Logger log = new Logger(KillUnreferencedSegmentSchema.class);
    private final SegmentSchemaManager segmentSchemaManager;

    public KillUnreferencedSegmentSchema(MetadataCleanupConfig config, SegmentSchemaManager segmentSchemaManager) {
        super("segmentSchema", config, Stats.Kill.SEGMENT_SCHEMA);
        this.segmentSchemaManager = segmentSchemaManager;
    }

    @Override
    protected int cleanupEntriesCreatedBefore(DateTime minCreatedTime) {
        int unused = this.segmentSchemaManager.markUnreferencedSchemasAsUnused();
        log.info("Marked [%s] unreferenced schemas as unused.", new Object[]{unused});
        List<String> schemaFingerprintsToUpdate = this.segmentSchemaManager.findReferencedSchemaMarkedAsUnused();
        if (!schemaFingerprintsToUpdate.isEmpty()) {
            int numUpdated = this.segmentSchemaManager.markSchemaAsUsed(schemaFingerprintsToUpdate);
            log.info("Marked [%s] unused schemas referenced by used segments as used.", new Object[]{numUpdated});
        }
        return this.segmentSchemaManager.deleteSchemasOlderThan(minCreatedTime.getMillis());
    }
}

