/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.common;

import com.github.rvesse.airline.annotations.restrictions.PortType;
import com.github.rvesse.airline.help.sections.HelpFormat;
import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseInvalidRestrictionException;
import com.github.rvesse.airline.parser.errors.ParseRestrictionViolatedException;
import com.github.rvesse.airline.restrictions.AbstractCommonRestriction;
import com.github.rvesse.airline.restrictions.common.PortRange;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class PortRestriction
extends AbstractCommonRestriction
implements HelpHint {
    private static final int MIN_PORT = 0;
    private static final int MAX_PORT = 65535;
    private Set<PortRange> acceptablePorts = new HashSet<PortRange>();

    public PortRestriction(PortRange ... portRanges) {
        this.acceptablePorts.addAll(Arrays.asList(portRanges));
    }

    @Override
    public <T> void postValidate(ParseState<T> state, OptionMetadata option, Object value) {
        if (this.acceptablePorts.isEmpty()) {
            return;
        }
        String title = AbstractCommonRestriction.getOptionTitle(state, option);
        if (value instanceof Long) {
            if (!this.isValid((Long)value)) {
                this.invalidOptionPort(option, title, value);
            }
        } else if (value instanceof Integer) {
            if (!this.isValid((Integer)value)) {
                this.invalidOptionPort(option, title, value);
            }
        } else if (value instanceof Short) {
            if (!this.isValid((Short)value)) {
                this.invalidOptionPort(option, title, value);
            }
        } else {
            throw new ParseInvalidRestrictionException("Cannot apply a @Port restriction to an option of type %s", option.getJavaType());
        }
    }

    protected void invalidOptionPort(OptionMetadata option, String title, Object value) {
        this.invalidPort(String.format("Option '%s'", title), value);
    }

    protected void invalidArgumentsPort(ArgumentsMetadata arguments, String title, Object value) {
        this.invalidPort(String.format("Argument '%s'", title), value);
    }

    protected void invalidPort(String title, Object value) {
        throw new ParseRestrictionViolatedException("Option '%s' which takes a port number was given a value '%s' which not in the range of acceptable ports: %s", title, value, PortType.toRangesString(this.acceptablePorts));
    }

    @Override
    public <T> void postValidate(ParseState<T> state, ArgumentsMetadata arguments, Object value) {
        if (this.acceptablePorts.isEmpty()) {
            return;
        }
        String title = PortRestriction.getArgumentTitle(state, arguments);
        if (value instanceof Long) {
            if (!this.isValid((Long)value)) {
                this.invalidArgumentsPort(arguments, title, value);
            }
        } else if (value instanceof Integer) {
            if (!this.isValid((Integer)value)) {
                this.invalidArgumentsPort(arguments, title, value);
            }
        } else if (value instanceof Short) {
            if (!this.isValid((Short)value)) {
                this.invalidArgumentsPort(arguments, title, value);
            }
        } else {
            throw new ParseInvalidRestrictionException("Cannot apply a @Port restriction to an option of type %s", arguments.getJavaType());
        }
    }

    private boolean isValid(long port) {
        if (port < 0L || port > 65535L) {
            return false;
        }
        if (this.acceptablePorts.contains(PortType.ANY)) {
            return true;
        }
        return this.inAnyAcceptableRange((int)port);
    }

    private boolean isValid(int port) {
        if (port < 0 || port > 65535) {
            return false;
        }
        if (this.acceptablePorts.contains(PortType.ANY)) {
            return true;
        }
        return this.inAnyAcceptableRange(port);
    }

    private boolean isValid(short port) {
        if (port < 0 || port > 65535) {
            return false;
        }
        if (this.acceptablePorts.contains(PortType.ANY)) {
            return true;
        }
        return this.inAnyAcceptableRange(port);
    }

    protected boolean inAnyAcceptableRange(int port) {
        for (PortRange range : this.acceptablePorts) {
            if (!range.inRange(port)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getPreamble() {
        return null;
    }

    @Override
    public HelpFormat getFormat() {
        return HelpFormat.PROSE;
    }

    @Override
    public int numContentBlocks() {
        return 1;
    }

    @Override
    public String[] getContentBlock(int blockNumber) {
        if (blockNumber != 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.acceptablePorts.contains(PortType.ANY)) {
            return new String[]{String.format("This options value represents a port and must fall in the port range %s", PortType.ANY.toString())};
        }
        return new String[]{String.format("This options value represents a port and must fall in one of the following port ranges: %s", PortType.toRangesString(this.acceptablePorts))};
    }
}

