/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.SafeMath;
import it.unimi.dsi.fastutil.bytes.AbstractByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteBigListIterator;
import it.unimi.dsi.fastutil.bytes.ByteConsumer;
import it.unimi.dsi.fastutil.bytes.ByteListIterator;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;

public final class ByteBigListIterators {
    public static final EmptyBigListIterator EMPTY_BIG_LIST_ITERATOR = new EmptyBigListIterator();

    private ByteBigListIterators() {
    }

    public static ByteBigListIterator singleton(byte element) {
        return new SingletonBigListIterator(element);
    }

    public static ByteBigListIterator unmodifiable(ByteBigListIterator i) {
        return new UnmodifiableBigListIterator(i);
    }

    public static ByteBigListIterator asBigListIterator(ByteListIterator i) {
        return new BigListIteratorListIterator(i);
    }

    private static class SingletonBigListIterator
    implements ByteBigListIterator {
        private final byte element;
        private int curr;

        public SingletonBigListIterator(byte element) {
            this.element = element;
        }

        public boolean hasNext() {
            return this.curr == 0;
        }

        public boolean hasPrevious() {
            return this.curr == 1;
        }

        public byte nextByte() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = 1;
            return this.element;
        }

        @Override
        public byte previousByte() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = 0;
            return this.element;
        }

        public void forEachRemaining(ByteConsumer action) {
            Objects.requireNonNull(action);
            if (this.curr == 0) {
                action.accept(this.element);
                this.curr = 1;
            }
        }

        public long nextIndex() {
            return this.curr;
        }

        public long previousIndex() {
            return this.curr - 1;
        }

        @Override
        public long back(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("Argument must be nonnegative: " + n);
            }
            if (n == 0L || this.curr < 1) {
                return 0L;
            }
            this.curr = 1;
            return 1L;
        }

        @Override
        public long skip(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("Argument must be nonnegative: " + n);
            }
            if (n == 0L || this.curr > 0) {
                return 0L;
            }
            this.curr = 0;
            return 1L;
        }
    }

    public static class UnmodifiableBigListIterator
    implements ByteBigListIterator {
        protected final ByteBigListIterator i;

        public UnmodifiableBigListIterator(ByteBigListIterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public byte nextByte() {
            return this.i.nextByte();
        }

        @Override
        public byte previousByte() {
            return this.i.previousByte();
        }

        public long nextIndex() {
            return this.i.nextIndex();
        }

        public long previousIndex() {
            return this.i.previousIndex();
        }

        public void forEachRemaining(ByteConsumer action) {
            this.i.forEachRemaining(action);
        }

        @Deprecated
        public void forEachRemaining(Consumer<? super Byte> action) {
            this.i.forEachRemaining(action);
        }
    }

    public static class BigListIteratorListIterator
    implements ByteBigListIterator {
        protected final ByteListIterator i;

        protected BigListIteratorListIterator(ByteListIterator i) {
            this.i = i;
        }

        private int intDisplacement(long n) {
            if (n < Integer.MIN_VALUE || n > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("This big iterator is restricted to 32-bit displacements");
            }
            return (int)n;
        }

        @Override
        public void set(byte ok) {
            this.i.set(ok);
        }

        @Override
        public void add(byte ok) {
            this.i.add(ok);
        }

        @Override
        public int back(int n) {
            return this.i.back(n);
        }

        @Override
        public long back(long n) {
            return this.i.back(this.intDisplacement(n));
        }

        public void remove() {
            this.i.remove();
        }

        @Override
        public int skip(int n) {
            return this.i.skip(n);
        }

        @Override
        public long skip(long n) {
            return this.i.skip(this.intDisplacement(n));
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public byte nextByte() {
            return this.i.nextByte();
        }

        @Override
        public byte previousByte() {
            return this.i.previousByte();
        }

        public long nextIndex() {
            return this.i.nextIndex();
        }

        public long previousIndex() {
            return this.i.previousIndex();
        }

        public void forEachRemaining(ByteConsumer action) {
            this.i.forEachRemaining(action);
        }

        @Deprecated
        public void forEachRemaining(Consumer<? super Byte> action) {
            this.i.forEachRemaining(action);
        }
    }

    public static class EmptyBigListIterator
    implements ByteBigListIterator,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyBigListIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public boolean hasPrevious() {
            return false;
        }

        public byte nextByte() {
            throw new NoSuchElementException();
        }

        @Override
        public byte previousByte() {
            throw new NoSuchElementException();
        }

        public long nextIndex() {
            return 0L;
        }

        public long previousIndex() {
            return -1L;
        }

        @Override
        public long skip(long n) {
            return 0L;
        }

        @Override
        public long back(long n) {
            return 0L;
        }

        public Object clone() {
            return EMPTY_BIG_LIST_ITERATOR;
        }

        public void forEachRemaining(ByteConsumer action) {
        }

        @Deprecated
        public void forEachRemaining(Consumer<? super Byte> action) {
        }

        private Object readResolve() {
            return EMPTY_BIG_LIST_ITERATOR;
        }
    }

    public static abstract class AbstractIndexBasedBigListIterator
    extends AbstractIndexBasedBigIterator
    implements ByteBigListIterator {
        protected AbstractIndexBasedBigListIterator(long minPos, long initialPos) {
            super(minPos, initialPos);
        }

        protected abstract void add(long var1, byte var3);

        protected abstract void set(long var1, byte var3);

        public boolean hasPrevious() {
            return this.pos > this.minPos;
        }

        @Override
        public byte previousByte() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = --this.pos;
            return this.get(this.pos);
        }

        public long nextIndex() {
            return this.pos;
        }

        public long previousIndex() {
            return this.pos - 1L;
        }

        @Override
        public void add(byte k) {
            this.add(this.pos++, k);
            this.lastReturned = -1L;
        }

        @Override
        public void set(byte k) {
            if (this.lastReturned == -1L) {
                throw new IllegalStateException();
            }
            this.set(this.lastReturned, k);
        }

        @Override
        public long back(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("Argument must be nonnegative: " + n);
            }
            long remaining = this.pos - this.minPos;
            if (n < remaining) {
                this.pos -= n;
            } else {
                n = remaining;
                this.pos = this.minPos;
            }
            this.lastReturned = this.pos;
            return n;
        }
    }

    public static abstract class AbstractIndexBasedBigIterator
    extends AbstractByteIterator {
        protected final long minPos;
        protected long pos;
        protected long lastReturned;

        protected AbstractIndexBasedBigIterator(long minPos, long initialPos) {
            this.minPos = minPos;
            this.pos = initialPos;
        }

        protected abstract byte get(long var1);

        protected abstract void remove(long var1);

        protected abstract long getMaxPos();

        public boolean hasNext() {
            return this.pos < this.getMaxPos();
        }

        public byte nextByte() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.pos++;
            return this.get(this.lastReturned);
        }

        public void remove() {
            if (this.lastReturned == -1L) {
                throw new IllegalStateException();
            }
            this.remove(this.lastReturned);
            if (this.lastReturned < this.pos) {
                --this.pos;
            }
            this.lastReturned = -1L;
        }

        public void forEachRemaining(ByteConsumer action) {
            while (this.pos < this.getMaxPos()) {
                ++this.pos;
                this.lastReturned = this.lastReturned;
                action.accept(this.get(this.lastReturned));
            }
        }

        public long skip(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("Argument must be nonnegative: " + n);
            }
            long max = this.getMaxPos();
            long remaining = max - this.pos;
            if (n < remaining) {
                this.pos += n;
            } else {
                n = remaining;
                this.pos = max;
            }
            this.lastReturned = this.pos - 1L;
            return n;
        }

        public int skip(int n) {
            return SafeMath.safeLongToInt((long)this.skip((long)n));
        }
    }
}

