/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class S3ListResult {
    private ObjectListing v1Result;
    private ListObjectsV2Result v2Result;

    protected S3ListResult(ObjectListing v1, ListObjectsV2Result v2) {
        this.v1Result = v1;
        this.v2Result = v2;
    }

    public static S3ListResult v1(ObjectListing result) {
        return new S3ListResult(result, null);
    }

    public static S3ListResult v2(ListObjectsV2Result result) {
        return new S3ListResult(null, result);
    }

    public boolean isV1() {
        return this.v1Result != null;
    }

    public ObjectListing getV1() {
        return this.v1Result;
    }

    public ListObjectsV2Result getV2() {
        return this.v2Result;
    }

    public List<S3ObjectSummary> getObjectSummaries() {
        if (this.isV1()) {
            return this.v1Result.getObjectSummaries();
        }
        return this.v2Result.getObjectSummaries();
    }

    public boolean isTruncated() {
        if (this.isV1()) {
            return this.v1Result.isTruncated();
        }
        return this.v2Result.isTruncated();
    }

    public List<String> getCommonPrefixes() {
        if (this.isV1()) {
            return this.v1Result.getCommonPrefixes();
        }
        return this.v2Result.getCommonPrefixes();
    }

    private List<String> objectSummaryKeys() {
        return this.getObjectSummaries().stream().map(S3ObjectSummary::getKey).collect(Collectors.toList());
    }

    public boolean hasPrefixesOrObjects() {
        return !this.getCommonPrefixes().isEmpty() || !this.getObjectSummaries().isEmpty();
    }

    public boolean representsEmptyDirectory(String dirKey) {
        List<String> keys = this.objectSummaryKeys();
        return keys.size() == 1 && keys.contains(dirKey) && this.getCommonPrefixes().isEmpty();
    }

    public void logAtDebug(Logger log) {
        List<String> prefixes = this.getCommonPrefixes();
        List<S3ObjectSummary> summaries = this.getObjectSummaries();
        log.debug("Prefix count = {}; object count={}", (Object)prefixes.size(), (Object)summaries.size());
        for (S3ObjectSummary summary : summaries) {
            log.debug("Summary: {} {}", (Object)summary.getKey(), (Object)summary.getSize());
        }
        for (String prefix : prefixes) {
            log.debug("Prefix: {}", (Object)prefix);
        }
    }
}

