/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.common.base.Supplier;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.common.config.ConfigManagerConfig;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.MetadataStorageTablesConfig;

public class JacksonConfigManagerModule
implements Module {
    public void configure(Binder binder) {
        JsonConfigProvider.bind(binder, "druid.manager.config", ConfigManagerConfig.class);
        binder.bind(JacksonConfigManager.class).in(LazySingleton.class);
    }

    @Provides
    @ManageLifecycle
    public ConfigManager getConfigManager(final MetadataStorageConnector dbConnector, Supplier<MetadataStorageTablesConfig> dbTables, Supplier<ConfigManagerConfig> config, Lifecycle lifecycle) {
        lifecycle.addHandler(new Lifecycle.Handler(){

            @Override
            public void start() {
                dbConnector.createConfigTable();
            }

            @Override
            public void stop() {
            }
        });
        return new ConfigManager(dbConnector, dbTables, config);
    }
}

