/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.collect.ImmutableMap;
import org.apache.druid.java.util.emitter.core.ConcurrentTimeCounter;
import org.apache.druid.java.util.emitter.core.HttpPostEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.FeedDefiningMonitor;

public class HttpPostEmitterMonitor
extends FeedDefiningMonitor {
    private final HttpPostEmitter httpPostEmitter;
    private final ImmutableMap<String, String> extraDimensions;
    private final ServiceMetricEvent.Builder builder;
    private long lastTotalEmittedEvents = 0L;
    private int lastTotalDroppedBuffers = 0;
    private int lastTotalAllocatedBuffers = 0;
    private int lastTotalFailedBuffers = 0;

    public HttpPostEmitterMonitor(String feed, HttpPostEmitter httpPostEmitter, ImmutableMap<String, String> extraDimensions) {
        super(feed);
        this.httpPostEmitter = httpPostEmitter;
        this.extraDimensions = extraDimensions;
        this.builder = this.builder();
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        this.emitEmittedEvents(emitter);
        this.emitDroppedBuffers(emitter);
        this.emitAllocatedBuffers(emitter);
        this.emitFailedBuffers(emitter);
        this.emitTimeCounterMetrics(emitter, this.httpPostEmitter.getBatchFillingTimeCounter(), "emitter/batchFilling/");
        this.emitTimeCounterMetrics(emitter, this.httpPostEmitter.getSuccessfulSendingTimeCounter(), "emitter/successfulSending/");
        this.emitTimeCounterMetrics(emitter, this.httpPostEmitter.getFailedSendingTimeCounter(), "emitter/failedSending/");
        emitter.emit(this.builder.setMetric("emitter/events/emitQueue", this.httpPostEmitter.getEventsToEmit()));
        emitter.emit(this.builder.setMetric("emitter/events/large/emitQueue", this.httpPostEmitter.getLargeEventsToEmit()));
        emitter.emit(this.builder.setMetric("emitter/buffers/emitQueue", this.httpPostEmitter.getBuffersToEmit()));
        emitter.emit(this.builder.setMetric("emitter/buffers/reuseQueue", this.httpPostEmitter.getBuffersToReuse()));
        return true;
    }

    private void emitEmittedEvents(ServiceEmitter emitter) {
        long newTotalEmittedEvents = this.httpPostEmitter.getTotalEmittedEvents();
        long emittedEventsDelta = newTotalEmittedEvents - this.lastTotalEmittedEvents;
        emitter.emit(this.builder.setMetric("emitter/events/emitted/delta", emittedEventsDelta));
        this.lastTotalEmittedEvents = newTotalEmittedEvents;
    }

    private void emitDroppedBuffers(ServiceEmitter emitter) {
        int newTotalDroppedBuffers = this.httpPostEmitter.getTotalDroppedBuffers();
        int droppedBuffersDelta = newTotalDroppedBuffers - this.lastTotalDroppedBuffers;
        emitter.emit(this.builder.setMetric("emitter/buffers/dropped/delta", droppedBuffersDelta));
        this.lastTotalDroppedBuffers = newTotalDroppedBuffers;
    }

    private void emitAllocatedBuffers(ServiceEmitter emitter) {
        int newTotalAllocatedBuffers = this.httpPostEmitter.getTotalAllocatedBuffers();
        int allocatedBuffersDelta = newTotalAllocatedBuffers - this.lastTotalAllocatedBuffers;
        emitter.emit(this.builder.setMetric("emitter/buffers/allocated/delta", allocatedBuffersDelta));
        this.lastTotalAllocatedBuffers = newTotalAllocatedBuffers;
    }

    private void emitFailedBuffers(ServiceEmitter emitter) {
        int newTotalFailedBuffers = this.httpPostEmitter.getTotalFailedBuffers();
        int failedBuffersDelta = newTotalFailedBuffers - this.lastTotalFailedBuffers;
        emitter.emit(this.builder.setMetric("emitter/buffers/failed/delta", failedBuffersDelta));
        this.lastTotalFailedBuffers = newTotalFailedBuffers;
    }

    private void emitTimeCounterMetrics(ServiceEmitter emitter, ConcurrentTimeCounter timeCounter, String metricNameBase) {
        Integer minTime;
        Integer maxTime;
        long timeSumAndCount = timeCounter.getTimeSumAndCountAndReset();
        int timeSum = ConcurrentTimeCounter.timeSum(timeSumAndCount);
        int count = ConcurrentTimeCounter.count(timeSumAndCount);
        if (count != 0) {
            emitter.emit(this.builder.setMetric(metricNameBase + "timeMsSum", timeSum));
            emitter.emit(this.builder.setMetric(metricNameBase + "count", count));
        }
        if ((maxTime = timeCounter.getAndResetMaxTime()) != null) {
            emitter.emit(this.builder.setMetric(metricNameBase + "maxTimeMs", maxTime));
        }
        if ((minTime = timeCounter.getAndResetMinTime()) != null) {
            emitter.emit(this.builder.setMetric(metricNameBase + "minTimeMs", minTime));
        }
    }

    @Override
    protected ServiceMetricEvent.Builder builder() {
        ServiceMetricEvent.Builder builder = super.builder();
        this.extraDimensions.forEach(builder::setDimension);
        return builder;
    }
}

