/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.collect.Utils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;

public class GroupByQueryResources
implements Closeable {
    private static final Logger log = new Logger(GroupByQueryResources.class);
    private static final int MAX_MERGE_BUFFER_NUM_WITHOUT_SUBTOTAL = 2;
    @Nullable
    private final List<ReferenceCountingResourceHolder<ByteBuffer>> toolchestMergeBuffersHolders;
    private final Deque<ByteBuffer> toolchestMergeBuffers = new ArrayDeque<ByteBuffer>();
    @Nullable
    private final List<ReferenceCountingResourceHolder<ByteBuffer>> mergingQueryRunnerMergeBuffersHolders;
    private final Deque<ByteBuffer> mergingQueryRunnerMergeBuffers = new ArrayDeque<ByteBuffer>();

    private static int countRequiredMergeBufferNumWithoutSubtotal(Query query, int foundNum) {
        DataSource dataSource = query.getDataSource();
        if (foundNum == 3 || !(dataSource instanceof QueryDataSource)) {
            return foundNum - 1;
        }
        return GroupByQueryResources.countRequiredMergeBufferNumWithoutSubtotal(((QueryDataSource)dataSource).getQuery(), foundNum + 1);
    }

    private static int numMergeBuffersNeededForSubtotalsSpec(GroupByQuery query) {
        Query subQuery;
        List<List<String>> subtotalSpecs = query.getSubtotalsSpec();
        DataSource dataSource = query.getDataSource();
        int numMergeBuffersNeededForSubQuerySubtotal = 0;
        if (dataSource instanceof QueryDataSource && (subQuery = ((QueryDataSource)dataSource).getQuery()) instanceof GroupByQuery) {
            numMergeBuffersNeededForSubQuerySubtotal = GroupByQueryResources.numMergeBuffersNeededForSubtotalsSpec((GroupByQuery)subQuery);
        }
        if (subtotalSpecs == null || subtotalSpecs.size() == 0) {
            return numMergeBuffersNeededForSubQuerySubtotal;
        }
        List queryDimOutputNames = query.getDimensions().stream().map(DimensionSpec::getOutputName).collect(Collectors.toList());
        for (List<String> subtotalSpec : subtotalSpecs) {
            if (Utils.isPrefix(subtotalSpec, queryDimOutputNames)) continue;
            return 2;
        }
        return Math.max(1, numMergeBuffersNeededForSubQuerySubtotal);
    }

    @VisibleForTesting
    public static int countRequiredMergeBufferNumForToolchestMerge(GroupByQuery query) {
        return GroupByQueryResources.countRequiredMergeBufferNumWithoutSubtotal(query, 1) + GroupByQueryResources.numMergeBuffersNeededForSubtotalsSpec(query);
    }

    public static int countRequiredMergeBufferNumForMergingQueryRunner(GroupByQueryConfig config, GroupByQuery query) {
        GroupByQueryConfig querySpecificConfig = config.withOverrides(query);
        return querySpecificConfig.getNumParallelCombineThreads() > 1 ? 2 : 1;
    }

    public GroupByQueryResources(@Nullable List<ReferenceCountingResourceHolder<ByteBuffer>> toolchestMergeBuffersHolders, @Nullable List<ReferenceCountingResourceHolder<ByteBuffer>> mergingQueryRunnerMergeBuffersHolders) {
        this.toolchestMergeBuffersHolders = toolchestMergeBuffersHolders;
        if (toolchestMergeBuffersHolders != null) {
            toolchestMergeBuffersHolders.forEach(holder -> this.toolchestMergeBuffers.add((ByteBuffer)holder.get()));
        }
        this.mergingQueryRunnerMergeBuffersHolders = mergingQueryRunnerMergeBuffersHolders;
        if (mergingQueryRunnerMergeBuffersHolders != null) {
            mergingQueryRunnerMergeBuffersHolders.forEach(holder -> this.mergingQueryRunnerMergeBuffers.add((ByteBuffer)holder.get()));
        }
    }

    public ResourceHolder<ByteBuffer> getToolchestMergeBuffer() {
        return GroupByQueryResources.getMergeBuffer(this.toolchestMergeBuffers);
    }

    public ResourceHolder<ByteBuffer> getMergingQueryRunnerMergeBuffer() {
        return GroupByQueryResources.getMergeBuffer(this.mergingQueryRunnerMergeBuffers);
    }

    public int getNumMergingQueryRunnerMergeBuffers() {
        return this.mergingQueryRunnerMergeBuffers.size();
    }

    private static ResourceHolder<ByteBuffer> getMergeBuffer(final Deque<ByteBuffer> acquiredBufferPool) {
        if (acquiredBufferPool.size() == 0) {
            throw DruidException.defensive("Insufficient free merge buffers present.", new Object[0]);
        }
        final ByteBuffer buffer = acquiredBufferPool.pop();
        return new ResourceHolder<ByteBuffer>(){

            @Override
            public ByteBuffer get() {
                return buffer;
            }

            @Override
            public void close() {
                acquiredBufferPool.add(buffer);
            }
        };
    }

    @Override
    public void close() {
        if (this.toolchestMergeBuffersHolders != null) {
            if (this.toolchestMergeBuffers.size() != this.toolchestMergeBuffersHolders.size()) {
                log.warn("%d toolchest merge buffers are not returned yet", this.toolchestMergeBuffersHolders.size() - this.toolchestMergeBuffers.size());
            }
            this.toolchestMergeBuffersHolders.forEach(ReferenceCountingResourceHolder::close);
        }
        if (this.mergingQueryRunnerMergeBuffersHolders != null) {
            if (this.mergingQueryRunnerMergeBuffers.size() != this.mergingQueryRunnerMergeBuffersHolders.size()) {
                log.warn("%d merging query runner merge buffers are not returned yet", this.mergingQueryRunnerMergeBuffersHolders.size() - this.mergingQueryRunnerMergeBuffers.size());
            }
            this.mergingQueryRunnerMergeBuffersHolders.forEach(ReferenceCountingResourceHolder::close);
        }
    }
}

