/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.operator.ColumnWithDirection;
import org.apache.druid.query.operator.OffsetLimit;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.operator.OperatorFactory;
import org.apache.druid.query.operator.ScanOperator;
import org.apache.druid.segment.VirtualColumns;
import org.joda.time.Interval;

public class ScanOperatorFactory
implements OperatorFactory {
    private final Interval timeRange;
    private final DimFilter filter;
    private final OffsetLimit offsetLimit;
    private final List<String> projectedColumns;
    private final VirtualColumns virtualColumns;
    private final List<ColumnWithDirection> ordering;

    public ScanOperatorFactory(@JsonProperty(value="timeRange") Interval timeRange, @JsonProperty(value="filter") DimFilter filter, @JsonProperty(value="offsetLimit") OffsetLimit offsetLimit, @JsonProperty(value="projectedColumns") List<String> projectedColumns, @JsonProperty(value="virtualColumns") VirtualColumns virtualColumns, @JsonProperty(value="ordering") List<ColumnWithDirection> ordering) {
        this.timeRange = timeRange;
        this.filter = filter;
        this.offsetLimit = offsetLimit;
        this.projectedColumns = projectedColumns;
        this.virtualColumns = virtualColumns;
        this.ordering = ordering;
    }

    @JsonProperty
    public Interval getTimeRange() {
        return this.timeRange;
    }

    @JsonProperty
    public DimFilter getFilter() {
        return this.filter;
    }

    @JsonProperty
    public OffsetLimit getOffsetLimit() {
        return this.offsetLimit;
    }

    @JsonProperty
    public List<String> getProjectedColumns() {
        return this.projectedColumns;
    }

    @JsonProperty
    public VirtualColumns getVirtualColumns() {
        return this.virtualColumns;
    }

    @JsonProperty
    public List<ColumnWithDirection> getOrdering() {
        return this.ordering;
    }

    @Override
    public Operator wrap(Operator op) {
        return new ScanOperator(op, this.projectedColumns, this.virtualColumns, this.timeRange, this.filter == null ? null : this.filter.toFilter(), this.ordering, this.offsetLimit);
    }

    @Override
    public boolean validateEquivalent(OperatorFactory other) {
        return this.equals(other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanOperatorFactory that = (ScanOperatorFactory)o;
        return Objects.equals(this.timeRange, that.timeRange) && Objects.equals(this.filter, that.filter) && Objects.equals(this.offsetLimit, that.offsetLimit) && Objects.equals(this.projectedColumns, that.projectedColumns) && Objects.equals(this.virtualColumns, that.virtualColumns) && Objects.equals(this.ordering, that.ordering);
    }

    public int hashCode() {
        return Objects.hash(this.timeRange, this.filter, this.offsetLimit, this.projectedColumns, this.virtualColumns, this.ordering);
    }

    public String toString() {
        return "ScanOperatorFactory{timeRange=" + String.valueOf(this.timeRange) + ", filter=" + String.valueOf(this.filter) + ", offsetLimit=" + String.valueOf(this.offsetLimit) + ", projectedColumns=" + String.valueOf(this.projectedColumns) + ", virtualColumns=" + String.valueOf(this.virtualColumns) + ", ordering=" + String.valueOf(this.ordering) + "}";
    }
}

