/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import org.apache.druid.java.util.common.IAE;

public class IdMapping {
    private final Int2IntOpenHashMap forwardMapping;
    private final int[] reverseMapping;

    private IdMapping(Int2IntOpenHashMap forwardMapping, int[] reverseMapping) {
        this.forwardMapping = forwardMapping;
        if (forwardMapping.defaultReturnValue() != -1) {
            throw new IAE("forwardMapping.defaultReturnValue() should be -1", new Object[0]);
        }
        this.reverseMapping = reverseMapping;
    }

    public int getForwardedId(int id) {
        return this.forwardMapping.get(id);
    }

    public int getReverseId(int id) {
        if (id < 0 || id >= this.reverseMapping.length) {
            return -1;
        }
        return this.reverseMapping[id];
    }

    public int getValueCardinality() {
        return this.forwardMapping.size();
    }

    public static class Builder {
        private final Int2IntOpenHashMap forwardMapping;
        private final int[] reverseMapping;
        private int count = 0;
        private final boolean knownCardinality;

        public static Builder ofCardinality(int cardinality) {
            Int2IntOpenHashMap forwardMapping = new Int2IntOpenHashMap(cardinality);
            forwardMapping.defaultReturnValue(-1);
            int[] reverseMapping = new int[cardinality];
            return new Builder(forwardMapping, reverseMapping, true);
        }

        public static Builder ofUnknownCardinality() {
            Int2IntOpenHashMap forwardMapping = new Int2IntOpenHashMap();
            forwardMapping.defaultReturnValue(-1);
            return new Builder(forwardMapping, new int[0], false);
        }

        private Builder(Int2IntOpenHashMap forwardMapping, int[] reverseMapping, boolean knownCardinality) {
            this.forwardMapping = forwardMapping;
            this.reverseMapping = reverseMapping;
            this.knownCardinality = knownCardinality;
        }

        public void addMapping(int forwardId) {
            if (!this.knownCardinality) {
                throw new IAE("Cannot call addMapping on unknown cardinality, use addForwardMapping instead", new Object[0]);
            }
            this.forwardMapping.put(forwardId, this.count);
            this.reverseMapping[this.count++] = forwardId;
        }

        public void addForwardMapping(int forwardId) {
            if (this.knownCardinality) {
                throw new IAE("Cannot call addForwardMapping on known cardinality, use addMapping instead", new Object[0]);
            }
            this.forwardMapping.put(forwardId, this.count++);
        }

        public IdMapping build() {
            if (this.knownCardinality) {
                return new IdMapping(this.forwardMapping, this.reverseMapping);
            }
            int[] reverseMapping = new int[this.forwardMapping.size()];
            for (Int2IntMap.Entry e : this.forwardMapping.int2IntEntrySet()) {
                reverseMapping[e.getIntValue()] = e.getIntKey();
            }
            return new IdMapping(this.forwardMapping, reverseMapping);
        }
    }
}

