/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.function.Function;
import java.util.function.ToLongFunction;
import org.apache.druid.data.input.Row;
import org.apache.druid.segment.RowAdapter;

public class RowAdapters {
    private static final RowAdapter<? extends Row> STANDARD_ROW_ADAPTER = new RowAdapter<Row>(){

        @Override
        public ToLongFunction<Row> timestampFunction() {
            return Row::getTimestampFromEpoch;
        }

        @Override
        public Function<Row, Object> columnFunction(String columnName) {
            return r -> r.getRaw(columnName);
        }
    };

    private RowAdapters() {
    }

    public static <RowType extends Row> RowAdapter<RowType> standardRow() {
        return STANDARD_ROW_ADAPTER;
    }
}

