/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.error.DruidException;
import org.apache.druid.segment.data.ByteBufferWriter;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.file.SegmentFileBuilder;
import org.apache.druid.segment.file.SegmentFileMapper;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DictionaryEncodedValueIndex.class, name="dictionaryEncodedValueIndex"), @JsonSubTypes.Type(value=NullValueIndex.class, name="nullValueIndex")})
public abstract class BitmapIndexType {
    protected static final String TYPE_DICTIONARY = "dictionaryEncodedValueIndex";
    protected static final String TYPE_NULL = "nullValueIndex";

    public abstract Writer getWriter();

    public static class NullValueIndex
    extends BitmapIndexType {
        public static final NullValueIndex INSTANCE = new NullValueIndex();

        public static ImmutableBitmap read(ByteBuffer dataBuffer, ObjectStrategy<ImmutableBitmap> objectStrategy) {
            return objectStrategy.fromByteBufferWithSize(dataBuffer);
        }

        @Override
        public Writer getWriter() {
            return new Writer(){
                @Nullable
                protected ByteBufferWriter<ImmutableBitmap> writer;
                @Nullable
                protected MutableBitmap[] bitmaps;

                @Override
                public void openWriter(SegmentWriteOutMedium writeoutMedium, String columnName, ObjectStrategy<ImmutableBitmap> objectStrategy) throws IOException {
                    if (this.writer != null) {
                        throw DruidException.defensive("Writer already initiated", new Object[0]);
                    }
                    this.writer = new ByteBufferWriter<ImmutableBitmap>(writeoutMedium, objectStrategy);
                    this.writer.open();
                }

                @Override
                public void init(BitmapFactory bitmapFactory, int unused) {
                    if (this.bitmaps != null) {
                        throw DruidException.defensive("Bitmaps already initiated", new Object[0]);
                    }
                    this.bitmaps = new MutableBitmap[1];
                    this.bitmaps[0] = bitmapFactory.makeEmptyMutableBitmap();
                }

                @Override
                public void add(int row, int sortedId, @Nullable Object o) {
                    if (o == null) {
                        this.bitmaps[0].add(row);
                    }
                }

                @Override
                public void finalizeWriter(BitmapFactory bitmapFactory) throws IOException {
                    if (this.writer == null) {
                        throw DruidException.defensive("Writer not initiated yet", new Object[0]);
                    }
                    if (this.bitmaps == null) {
                        throw DruidException.defensive("Invalid state, missing bitmaps", new Object[0]);
                    }
                    this.writer.write(bitmapFactory.makeImmutableBitmap(this.bitmaps[0]));
                    this.bitmaps[0] = null;
                    this.bitmaps = null;
                }

                @Override
                public long getSerializedSize() {
                    if (this.writer == null) {
                        throw DruidException.defensive("Writer not initiated yet", new Object[0]);
                    }
                    return this.writer.getSerializedSize();
                }

                @Override
                public void writeTo(WritableByteChannel channel, SegmentFileBuilder fileBuilder) throws IOException {
                    if (this.writer == null) {
                        throw DruidException.defensive("Writer not initiated yet", new Object[0]);
                    }
                    this.writer.writeTo(channel, fileBuilder);
                }
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return Objects.hashCode(this.getClass());
        }

        public String toString() {
            return BitmapIndexType.TYPE_NULL;
        }
    }

    public static class DictionaryEncodedValueIndex
    extends BitmapIndexType {
        public static final DictionaryEncodedValueIndex INSTANCE = new DictionaryEncodedValueIndex();

        public static GenericIndexed<ImmutableBitmap> read(ByteBuffer dataBuffer, ObjectStrategy<ImmutableBitmap> objectStrategy, SegmentFileMapper fileMapper) {
            return GenericIndexed.read(dataBuffer, objectStrategy, fileMapper);
        }

        @Override
        public Writer getWriter() {
            return new Writer(){
                @Nullable
                private GenericIndexedWriter<ImmutableBitmap> writer;
                @Nullable
                private MutableBitmap[] bitmaps;

                @Override
                public void openWriter(SegmentWriteOutMedium writeoutMedium, String columnName, ObjectStrategy<ImmutableBitmap> objectStrategy) throws IOException {
                    if (this.writer != null) {
                        throw DruidException.defensive("Writer already initiated", new Object[0]);
                    }
                    this.writer = new GenericIndexedWriter<ImmutableBitmap>(writeoutMedium, columnName, objectStrategy);
                    this.writer.open();
                    this.writer.setObjectsNotSorted();
                }

                @Override
                public void init(BitmapFactory bitmapFactory, int dictionarySize) {
                    if (this.bitmaps != null) {
                        throw DruidException.defensive("Bitmaps already initiated", new Object[0]);
                    }
                    this.bitmaps = new MutableBitmap[dictionarySize];
                    for (int index = 0; index < dictionarySize; ++index) {
                        this.bitmaps[index] = bitmapFactory.makeEmptyMutableBitmap();
                    }
                }

                @Override
                public void add(int row, int sortedId, @Nullable Object o) {
                    this.bitmaps[sortedId].add(row);
                }

                @Override
                public void finalizeWriter(BitmapFactory bitmapFactory) throws IOException {
                    if (this.writer == null) {
                        throw DruidException.defensive("Writer not initiated yet", new Object[0]);
                    }
                    if (this.bitmaps == null) {
                        throw DruidException.defensive("Invalid state, missing bitmaps", new Object[0]);
                    }
                    for (int i = 0; i < this.bitmaps.length; ++i) {
                        this.writer.write(bitmapFactory.makeImmutableBitmap(this.bitmaps[i]));
                        this.bitmaps[i] = null;
                    }
                    this.bitmaps = null;
                }

                @Override
                public long getSerializedSize() {
                    if (this.writer == null) {
                        throw DruidException.defensive("Writer not initiated yet", new Object[0]);
                    }
                    return this.writer.getSerializedSize();
                }

                @Override
                public void writeTo(WritableByteChannel channel, SegmentFileBuilder fileBuilder) throws IOException {
                    if (this.writer == null) {
                        throw DruidException.defensive("Writer not initiated yet", new Object[0]);
                    }
                    this.writer.writeTo(channel, fileBuilder);
                }
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return Objects.hashCode(this.getClass());
        }

        public String toString() {
            return BitmapIndexType.TYPE_DICTIONARY;
        }
    }

    public static interface Writer
    extends Serializer {
        public void openWriter(SegmentWriteOutMedium var1, String var2, ObjectStrategy<ImmutableBitmap> var3) throws IOException;

        public void init(BitmapFactory var1, int var2);

        public void add(int var1, int var2, @Nullable Object var3);

        public void finalizeWriter(BitmapFactory var1) throws IOException;
    }
}

