/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.index;

import javax.annotation.Nullable;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.segment.index.SimpleImmutableBitmapDelegatingIterableIndex;

public abstract class DictionaryRangeScanningBitmapIndex
extends SimpleImmutableBitmapDelegatingIterableIndex {
    private final double sizeScale;
    private final int rangeSize;

    public DictionaryRangeScanningBitmapIndex(double sizeScale, int rangeSize) {
        this.sizeScale = sizeScale;
        this.rangeSize = rangeSize;
    }

    @Override
    public int estimatedComputeCost() {
        return this.rangeSize;
    }

    @Override
    @Nullable
    public final <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, int applyRowCount, int totalRowCount, boolean includeUnknown) {
        int scale = (int)Math.ceil(this.sizeScale * (double)applyRowCount);
        if (this.rangeSize > scale) {
            return null;
        }
        return this.computeBitmapResult(bitmapResultFactory, includeUnknown);
    }
}

