/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.RowIdSupplier;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.join.JoinMatcher;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.PossiblyNullColumnValueSelector;
import org.apache.druid.segment.join.PossiblyNullDimensionSelector;

public class HashJoinEngine {
    private HashJoinEngine() {
    }

    public static Cursor makeJoinCursor(final Cursor leftCursor, final JoinableClause joinableClause, Closer closer) {
        final ColumnSelectorFactory leftColumnSelectorFactory = leftCursor.getColumnSelectorFactory();
        final JoinMatcher joinMatcher = joinableClause.getJoinable().makeJoinMatcher(leftColumnSelectorFactory, joinableClause.getCondition(), joinableClause.getJoinType().isRighty(), closer);
        class JoinColumnSelectorFactory
        implements ColumnSelectorFactory,
        RowIdSupplier {
            private long rowId = 0L;

            JoinColumnSelectorFactory() {
            }

            @Override
            public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
                if (joinableClause.includesColumn(dimensionSpec.getDimension())) {
                    return joinMatcher.getColumnSelectorFactory().makeDimensionSelector(dimensionSpec.withDimension(joinableClause.unprefix(dimensionSpec.getDimension())));
                }
                DimensionSelector leftSelector = leftColumnSelectorFactory.makeDimensionSelector(dimensionSpec);
                if (!joinableClause.getJoinType().isRighty()) {
                    return leftSelector;
                }
                return new PossiblyNullDimensionSelector(leftSelector, joinMatcher::matchingRemainder);
            }

            @Override
            public ColumnValueSelector makeColumnValueSelector(String column) {
                if (joinableClause.includesColumn(column)) {
                    return joinMatcher.getColumnSelectorFactory().makeColumnValueSelector(joinableClause.unprefix(column));
                }
                ColumnValueSelector leftSelector = leftColumnSelectorFactory.makeColumnValueSelector(column);
                if (!joinableClause.getJoinType().isRighty()) {
                    return leftSelector;
                }
                return new PossiblyNullColumnValueSelector(leftSelector, joinMatcher::matchingRemainder);
            }

            @Override
            @Nullable
            public ColumnCapabilities getColumnCapabilities(String column) {
                if (joinableClause.includesColumn(column)) {
                    return joinMatcher.getColumnSelectorFactory().getColumnCapabilities(joinableClause.unprefix(column));
                }
                return leftColumnSelectorFactory.getColumnCapabilities(column);
            }

            @Override
            @Nullable
            public RowIdSupplier getRowIdSupplier() {
                return this;
            }

            @Override
            public long getRowId() {
                return this.rowId;
            }

            void advanceRowId() {
                ++this.rowId;
            }

            void resetRowId() {
                this.rowId = 0L;
            }
        }
        final JoinColumnSelectorFactory joinColumnSelectorFactory = new JoinColumnSelectorFactory();
        class JoinCursor
        implements Cursor {
            JoinCursor() {
            }

            public void initialize() {
                this.matchCurrentPosition();
                if (!joinableClause.getJoinType().isLefty()) {
                    while (!joinMatcher.hasMatch() && !this.isDone()) {
                        this.advance();
                        this.matchCurrentPosition();
                    }
                }
            }

            @Override
            @Nonnull
            public ColumnSelectorFactory getColumnSelectorFactory() {
                return joinColumnSelectorFactory;
            }

            @Override
            public void advance() {
                this.advance(true);
                BaseQuery.checkInterrupted();
            }

            private void matchCurrentPosition() {
                if (leftCursor.isDone()) {
                    if (joinableClause.getJoinType().isRighty() && !joinMatcher.matchingRemainder()) {
                        joinMatcher.matchRemainder();
                    }
                } else {
                    joinMatcher.matchCondition();
                }
            }

            @Override
            public void advanceUninterruptibly() {
                this.advance(false);
            }

            private void advance(boolean interruptibly) {
                joinColumnSelectorFactory.advanceRowId();
                if (joinMatcher.hasMatch()) {
                    joinMatcher.nextMatch();
                    if (joinMatcher.hasMatch()) {
                        return;
                    }
                }
                assert (!joinMatcher.hasMatch());
                if (leftCursor.isDone()) {
                    assert (this.isDone());
                    return;
                }
                do {
                    if (interruptibly) {
                        leftCursor.advance();
                    } else {
                        leftCursor.advanceUninterruptibly();
                    }
                    this.matchCurrentPosition();
                } while (!joinableClause.getJoinType().isLefty() && !joinMatcher.hasMatch() && !leftCursor.isDone());
            }

            @Override
            public boolean isDone() {
                return leftCursor.isDone() && !joinMatcher.hasMatch();
            }

            @Override
            public boolean isDoneOrInterrupted() {
                return this.isDone() || Thread.currentThread().isInterrupted();
            }

            @Override
            public void reset() {
                leftCursor.reset();
                joinMatcher.reset();
                joinColumnSelectorFactory.resetRowId();
                this.initialize();
            }
        }
        JoinCursor joinCursor = new JoinCursor();
        joinCursor.initialize();
        return joinCursor;
    }
}

