/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import it.unimi.dsi.fastutil.doubles.DoubleArraySet;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.annotations.SuppressFBWarnings;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.segment.IntListUtils;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexed;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.index.AllFalseBitmapColumnIndex;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.DictionaryRangeScanningBitmapIndex;
import org.apache.druid.segment.index.DictionaryScanningBitmapIndex;
import org.apache.druid.segment.index.SimpleBitmapColumnIndex;
import org.apache.druid.segment.index.SimpleImmutableBitmapDelegatingIterableIndex;
import org.apache.druid.segment.index.SimpleImmutableBitmapIndex;
import org.apache.druid.segment.index.semantic.ArrayElementIndexes;
import org.apache.druid.segment.index.semantic.DictionaryEncodedStringValueIndex;
import org.apache.druid.segment.index.semantic.DictionaryEncodedValueIndex;
import org.apache.druid.segment.index.semantic.DruidPredicateIndexes;
import org.apache.druid.segment.index.semantic.LexicographicalRangeIndexes;
import org.apache.druid.segment.index.semantic.NullValueIndex;
import org.apache.druid.segment.index.semantic.NumericRangeIndexes;
import org.apache.druid.segment.index.semantic.StringValueSetIndexes;
import org.apache.druid.segment.index.semantic.ValueIndexes;
import org.apache.druid.segment.nested.FieldTypeInfo;

public class NestedFieldColumnIndexSupplier<TStringDictionary extends Indexed<ByteBuffer>>
implements ColumnIndexSupplier {
    @Nullable
    private final ColumnType singleType;
    private final BitmapFactory bitmapFactory;
    private final GenericIndexed<ImmutableBitmap> bitmaps;
    private final Supplier<FixedIndexed<Integer>> localDictionarySupplier;
    private final Supplier<TStringDictionary> globalStringDictionarySupplier;
    private final Supplier<FixedIndexed<Long>> globalLongDictionarySupplier;
    private final Supplier<FixedIndexed<Double>> globalDoubleDictionarySupplier;
    private final Supplier<FrontCodedIntArrayIndexed> globalArrayDictionarySupplier;
    @Nullable
    private final GenericIndexed<ImmutableBitmap> arrayElementBitmaps;
    @Nullable
    private final Supplier<FixedIndexed<Integer>> arrayElementDictionarySupplier;
    private final int adjustLongId;
    private final int adjustDoubleId;
    private final int adjustArrayId;
    private final ColumnConfig columnConfig;

    public NestedFieldColumnIndexSupplier(FieldTypeInfo.TypeSet types, BitmapFactory bitmapFactory, ColumnConfig columnConfig, GenericIndexed<ImmutableBitmap> bitmaps, Supplier<FixedIndexed<Integer>> localDictionarySupplier, Supplier<TStringDictionary> globalStringDictionarySupplier, Supplier<FixedIndexed<Long>> globalLongDictionarySupplier, Supplier<FixedIndexed<Double>> globalDoubleDictionarySupplier, @Nullable Supplier<FrontCodedIntArrayIndexed> globalArrayDictionarySupplier, @Nullable Supplier<FixedIndexed<Integer>> arrayElementDictionarySupplier, @Nullable GenericIndexed<ImmutableBitmap> arrayElementBitmaps) {
        this.singleType = types.getSingleType();
        this.bitmapFactory = bitmapFactory;
        this.bitmaps = bitmaps;
        this.localDictionarySupplier = localDictionarySupplier;
        this.globalStringDictionarySupplier = globalStringDictionarySupplier;
        this.globalLongDictionarySupplier = globalLongDictionarySupplier;
        this.globalDoubleDictionarySupplier = globalDoubleDictionarySupplier;
        this.globalArrayDictionarySupplier = globalArrayDictionarySupplier;
        this.arrayElementDictionarySupplier = arrayElementDictionarySupplier;
        this.arrayElementBitmaps = arrayElementBitmaps;
        this.adjustLongId = ((Indexed)globalStringDictionarySupplier.get()).size();
        this.adjustDoubleId = this.adjustLongId + ((FixedIndexed)globalLongDictionarySupplier.get()).size();
        this.adjustArrayId = this.adjustDoubleId + ((FixedIndexed)globalDoubleDictionarySupplier.get()).size();
        this.columnConfig = columnConfig;
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        if (clazz.equals(NullValueIndex.class)) {
            SimpleImmutableBitmapIndex nullIndex = (Integer)((FixedIndexed)this.localDictionarySupplier.get()).get(0) == 0 ? new SimpleImmutableBitmapIndex((ImmutableBitmap)this.bitmaps.get(0)) : new SimpleImmutableBitmapIndex(this.bitmapFactory.makeEmptyImmutableBitmap());
            return (T)((NullValueIndex)() -> nullIndex);
        }
        if (clazz.equals(DictionaryEncodedStringValueIndex.class) || clazz.equals(DictionaryEncodedValueIndex.class)) {
            return (T)new NestedFieldDictionaryEncodedStringValueIndex();
        }
        if (this.singleType != null) {
            switch ((ValueType)this.singleType.getType()) {
                case STRING: {
                    if (clazz.equals(StringValueSetIndexes.class)) {
                        return (T)new NestedStringValueSetIndexes();
                    }
                    if (clazz.equals(LexicographicalRangeIndexes.class)) {
                        return (T)new NestedStringLexicographicalRangeIndexes();
                    }
                    if (clazz.equals(DruidPredicateIndexes.class)) {
                        return (T)new NestedStringPredicateIndexes();
                    }
                    return null;
                }
                case LONG: {
                    if (clazz.equals(ValueIndexes.class)) {
                        return (T)new NestedLongValueIndexes();
                    }
                    if (clazz.equals(StringValueSetIndexes.class)) {
                        return (T)new NestedLongStringValueSetIndex();
                    }
                    if (clazz.equals(NumericRangeIndexes.class)) {
                        return (T)new NestedLongNumericRangeIndexes();
                    }
                    if (clazz.equals(DruidPredicateIndexes.class)) {
                        return (T)new NestedLongPredicateIndexes();
                    }
                    return null;
                }
                case DOUBLE: {
                    if (clazz.equals(ValueIndexes.class)) {
                        return (T)new NestedDoubleValueIndexes();
                    }
                    if (clazz.equals(StringValueSetIndexes.class)) {
                        return (T)new NestedDoubleStringValueSetIndex();
                    }
                    if (clazz.equals(NumericRangeIndexes.class)) {
                        return (T)new NestedDoubleNumericRangeIndexes();
                    }
                    if (clazz.equals(DruidPredicateIndexes.class)) {
                        return (T)new NestedDoublePredicateIndexes();
                    }
                    return null;
                }
                case ARRAY: {
                    if (clazz.equals(ValueIndexes.class)) {
                        return (T)new NestedArrayValueIndexes();
                    }
                    if (clazz.equals(ArrayElementIndexes.class)) {
                        return (T)new NestedArrayElementIndexes();
                    }
                    return null;
                }
            }
            return null;
        }
        if (clazz.equals(StringValueSetIndexes.class)) {
            return (T)new NestedVariantStringValueSetIndexes();
        }
        if (clazz.equals(DruidPredicateIndexes.class)) {
            return (T)new NestedVariantPredicateIndexes();
        }
        return null;
    }

    private ImmutableBitmap getBitmap(int idx) {
        if (idx < 0) {
            return this.bitmapFactory.makeEmptyImmutableBitmap();
        }
        ImmutableBitmap bitmap = (ImmutableBitmap)this.bitmaps.get(idx);
        return bitmap == null ? this.bitmapFactory.makeEmptyImmutableBitmap() : bitmap;
    }

    private <T> IntIntPair getLocalRangeFromDictionary(@Nullable T startValue, boolean startStrict, @Nullable T endValue, boolean endStrict, Indexed<Integer> localDictionary, Indexed<T> globalDictionary, int adjust) {
        int found;
        int globalStartIndex = startValue == null ? (adjust == 0 ? 1 : adjust) : ((found = globalDictionary.indexOf(startValue)) >= 0 ? adjust + (startStrict ? found + 1 : found) : adjust + -(found + 1));
        int globalEndIndex = endValue == null ? globalDictionary.size() + adjust : ((found = globalDictionary.indexOf(endValue)) >= 0 ? adjust + (endStrict ? found : found + 1) : adjust + -(found + 1));
        if (globalStartIndex == (globalEndIndex = Math.max(globalStartIndex, globalEndIndex))) {
            return new IntIntImmutablePair(0, 0);
        }
        int localFound = localDictionary.indexOf(globalStartIndex);
        int localStartIndex = localFound < 0 ? -(localFound + 1) : localFound;
        int localEndFound = localDictionary.indexOf(globalEndIndex);
        int localEndIndex = localEndFound < 0 ? -(localEndFound + 1) : localEndFound;
        localStartIndex = Math.min(localStartIndex, localDictionary.size());
        localEndIndex = Math.max(localStartIndex, Math.min(localDictionary.size(), localEndIndex));
        return new IntIntImmutablePair(localStartIndex, localEndIndex);
    }

    @Nullable
    private <T> BitmapColumnIndex makeRangeIndex(@Nullable T startValue, boolean startStrict, @Nullable T endValue, boolean endStrict, final Indexed<Integer> localDictionary, Indexed<T> globalDictionary, int adjust, double rangeScale) {
        IntIntPair localRange = this.getLocalRangeFromDictionary(startValue, startStrict, endValue, endStrict, localDictionary, globalDictionary, adjust);
        final int startIndex = localRange.leftInt();
        final int endIndex = localRange.rightInt();
        int size = endIndex - startIndex;
        return new DictionaryRangeScanningBitmapIndex(rangeScale, size){

            @Override
            public Iterable<ImmutableBitmap> getBitmapIterable() {
                return () -> new Iterator<ImmutableBitmap>(){
                    final IntIterator rangeIterator;
                    {
                        this.rangeIterator = IntListUtils.fromTo(startIndex, endIndex).iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.rangeIterator.hasNext();
                    }

                    @Override
                    public ImmutableBitmap next() {
                        return NestedFieldColumnIndexSupplier.this.getBitmap(this.rangeIterator.nextInt());
                    }
                };
            }

            @Override
            @Nullable
            protected ImmutableBitmap getUnknownsBitmap() {
                if ((Integer)localDictionary.get(0) == 0) {
                    return (ImmutableBitmap)NestedFieldColumnIndexSupplier.this.bitmaps.get(0);
                }
                return null;
            }
        };
    }

    private class NestedFieldDictionaryEncodedStringValueIndex
    implements DictionaryEncodedStringValueIndex {
        final FixedIndexed<Integer> localDictionary;
        final Indexed<ByteBuffer> stringDictionary;
        final FixedIndexed<Long> longDictionary;
        final FixedIndexed<Double> doubleDictionary;

        private NestedFieldDictionaryEncodedStringValueIndex() {
            this.localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
            this.stringDictionary = (Indexed)NestedFieldColumnIndexSupplier.this.globalStringDictionarySupplier.get();
            this.longDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.globalLongDictionarySupplier.get();
            this.doubleDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.globalDoubleDictionarySupplier.get();
        }

        @Override
        public int getCardinality() {
            return this.localDictionary.size();
        }

        @Override
        @Nullable
        public String getValue(int index) {
            int globalIndex = this.localDictionary.get(index);
            if (globalIndex < NestedFieldColumnIndexSupplier.this.adjustLongId) {
                return StringUtils.fromUtf8Nullable(this.stringDictionary.get(globalIndex));
            }
            if (globalIndex < NestedFieldColumnIndexSupplier.this.adjustDoubleId) {
                return String.valueOf(this.longDictionary.get(globalIndex - NestedFieldColumnIndexSupplier.this.adjustLongId));
            }
            return String.valueOf(this.doubleDictionary.get(globalIndex - NestedFieldColumnIndexSupplier.this.adjustDoubleId));
        }

        @Override
        public BitmapFactory getBitmapFactory() {
            return NestedFieldColumnIndexSupplier.this.bitmapFactory;
        }

        @Override
        public ImmutableBitmap getBitmap(int idx) {
            return NestedFieldColumnIndexSupplier.this.getBitmap(idx);
        }
    }

    private class NestedStringValueSetIndexes
    implements StringValueSetIndexes {
        private NestedStringValueSetIndexes() {
        }

        @Override
        public BitmapColumnIndex forValue(final @Nullable String value) {
            return new SimpleBitmapColumnIndex(){
                final FixedIndexed<Integer> localDictionary;
                final Indexed<ByteBuffer> stringDictionary;
                {
                    this.localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
                    this.stringDictionary = (Indexed)NestedFieldColumnIndexSupplier.this.globalStringDictionarySupplier.get();
                }

                @Override
                public int estimatedComputeCost() {
                    return 1;
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
                    int globalId = this.stringDictionary.indexOf(StringUtils.toUtf8ByteBuffer(value));
                    if (includeUnknown && this.localDictionary.get(0) == 0) {
                        if (globalId < 0) {
                            return bitmapResultFactory.wrapDimensionValue((ImmutableBitmap)NestedFieldColumnIndexSupplier.this.bitmaps.get(0));
                        }
                        return bitmapResultFactory.unionDimensionValueBitmaps((Iterable<ImmutableBitmap>)ImmutableList.of((Object)NestedFieldColumnIndexSupplier.this.getBitmap(this.localDictionary.indexOf(globalId)), (Object)((ImmutableBitmap)NestedFieldColumnIndexSupplier.this.bitmaps.get(0))));
                    }
                    if (globalId < 0) {
                        return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.getBitmap(this.localDictionary.indexOf(globalId)));
                }
            };
        }

        @Override
        public BitmapColumnIndex forSortedValues(final SortedSet<String> values) {
            return new SimpleImmutableBitmapDelegatingIterableIndex(){

                @Override
                public int estimatedComputeCost() {
                    return values.size();
                }

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        final FixedIndexed<Integer> localDictionary;
                        final Indexed<ByteBuffer> stringDictionary;
                        final Iterator<String> iterator;
                        int next;
                        {
                            this.localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
                            this.stringDictionary = (Indexed)NestedFieldColumnIndexSupplier.this.globalStringDictionarySupplier.get();
                            this.iterator = values.iterator();
                            this.next = -1;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.next < 0) {
                                this.findNext();
                            }
                            return this.next >= 0;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (this.next < 0) {
                                this.findNext();
                                if (this.next < 0) {
                                    throw new NoSuchElementException();
                                }
                            }
                            int swap = this.next;
                            this.next = -1;
                            return NestedFieldColumnIndexSupplier.this.getBitmap(swap);
                        }

                        private void findNext() {
                            while (this.next < 0 && this.iterator.hasNext()) {
                                String nextValue = this.iterator.next();
                                this.next = this.localDictionary.indexOf(this.stringDictionary.indexOf(StringUtils.toUtf8ByteBuffer(nextValue)));
                            }
                        }
                    };
                }

                @Override
                @Nullable
                @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
                protected ImmutableBitmap getUnknownsBitmap() {
                    if (!values.contains(null) && (Integer)((FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get()).get(0) == 0) {
                        return (ImmutableBitmap)NestedFieldColumnIndexSupplier.this.bitmaps.get(0);
                    }
                    return null;
                }
            };
        }
    }

    private class NestedStringLexicographicalRangeIndexes
    implements LexicographicalRangeIndexes {
        private NestedStringLexicographicalRangeIndexes() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forRange(@Nullable String startValue, boolean startStrict, @Nullable String endValue, boolean endStrict) {
            return NestedFieldColumnIndexSupplier.this.makeRangeIndex(StringUtils.toUtf8ByteBuffer(startValue), startStrict, StringUtils.toUtf8ByteBuffer(endValue), endStrict, (Indexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get(), (Indexed)NestedFieldColumnIndexSupplier.this.globalStringDictionarySupplier.get(), 0, 1.0);
        }

        @Override
        @Nullable
        public BitmapColumnIndex forRange(@Nullable String startValue, boolean startStrict, @Nullable String endValue, boolean endStrict, final DruidObjectPredicate<String> matcher) {
            final FixedIndexed localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
            final Indexed stringDictionary = (Indexed)NestedFieldColumnIndexSupplier.this.globalStringDictionarySupplier.get();
            IntIntPair range = NestedFieldColumnIndexSupplier.this.getLocalRangeFromDictionary(StringUtils.toUtf8ByteBuffer(startValue), startStrict, StringUtils.toUtf8ByteBuffer(endValue), endStrict, localDictionary, stringDictionary, 0);
            final int start = range.leftInt();
            final int end = range.rightInt();
            return new DictionaryRangeScanningBitmapIndex(1.0, end - start){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        int currIndex;
                        int found;
                        {
                            this.currIndex = start;
                            this.found = this.findNext();
                        }

                        private int findNext() {
                            while (this.currIndex < end && !matcher.apply(StringUtils.fromUtf8Nullable((ByteBuffer)stringDictionary.get((Integer)localDictionary.get(this.currIndex)))).matches(false)) {
                                ++this.currIndex;
                            }
                            if (this.currIndex < end) {
                                return this.currIndex++;
                            }
                            return -1;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.found != -1;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            int cur = this.found;
                            if (cur == -1) {
                                throw new NoSuchElementException();
                            }
                            this.found = this.findNext();
                            return NestedFieldColumnIndexSupplier.this.getBitmap(cur);
                        }
                    };
                }

                @Override
                @Nullable
                protected ImmutableBitmap getUnknownsBitmap() {
                    if ((Integer)localDictionary.get(0) == 0) {
                        return (ImmutableBitmap)NestedFieldColumnIndexSupplier.this.bitmaps.get(0);
                    }
                    return null;
                }
            };
        }
    }

    private class NestedStringPredicateIndexes
    implements DruidPredicateIndexes {
        private NestedStringPredicateIndexes() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forPredicate(final DruidPredicateFactory matcherFactory) {
            final FixedIndexed localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
            return new DictionaryScanningBitmapIndex(localDictionary.size()){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable(final boolean includeUnknown) {
                    return () -> new Iterator<ImmutableBitmap>(){
                        final Indexed<ByteBuffer> stringDictionary;
                        final DruidObjectPredicate<String> stringPredicate;
                        final Iterator<Integer> iterator;
                        int index;
                        boolean nextSet;
                        {
                            this.stringDictionary = (Indexed)NestedFieldColumnIndexSupplier.this.globalStringDictionarySupplier.get();
                            this.stringPredicate = matcherFactory.makeStringPredicate();
                            this.iterator = localDictionary.iterator();
                            this.index = -1;
                            this.nextSet = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (!this.nextSet) {
                                this.findNext();
                            }
                            return this.nextSet;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (!this.nextSet) {
                                this.findNext();
                                if (!this.nextSet) {
                                    throw new NoSuchElementException();
                                }
                            }
                            this.nextSet = false;
                            return NestedFieldColumnIndexSupplier.this.getBitmap(this.index);
                        }

                        private void findNext() {
                            while (!this.nextSet && this.iterator.hasNext()) {
                                Integer nextValue = this.iterator.next();
                                ++this.index;
                                this.nextSet = this.stringPredicate.apply(StringUtils.fromUtf8Nullable(this.stringDictionary.get(nextValue))).matches(includeUnknown);
                            }
                        }
                    };
                }
            };
        }
    }

    private class NestedLongValueIndexes
    implements ValueIndexes {
        private NestedLongValueIndexes() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forValue(@Nonnull Object value, TypeSignature<ValueType> valueType) {
            ImmutableBitmap nullValueBitmap;
            ExprEval<?> eval = ExprEval.ofType(ExpressionType.fromColumnTypeStrict(valueType), value);
            ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(eval, ExpressionType.LONG);
            ImmutableBitmap immutableBitmap = nullValueBitmap = (Integer)((FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get()).get(0) == 0 ? (ImmutableBitmap)NestedFieldColumnIndexSupplier.this.bitmaps.get(0) : NestedFieldColumnIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap();
            if (castForComparison == null) {
                return new AllFalseBitmapColumnIndex(NestedFieldColumnIndexSupplier.this.bitmapFactory, nullValueBitmap);
            }
            final long longValue = castForComparison.asLong();
            return new SimpleBitmapColumnIndex(){
                final FixedIndexed<Integer> localDictionary;
                final FixedIndexed<Long> globalDictionary;
                {
                    this.localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
                    this.globalDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.globalLongDictionarySupplier.get();
                }

                @Override
                public int estimatedComputeCost() {
                    return 1;
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
                    int globalId = this.globalDictionary.indexOf(longValue);
                    if (globalId < 0) {
                        if (includeUnknown) {
                            return bitmapResultFactory.wrapDimensionValue(nullValueBitmap);
                        }
                        return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    int id = this.localDictionary.indexOf(globalId + NestedFieldColumnIndexSupplier.this.adjustLongId);
                    if (includeUnknown) {
                        if (id < 0) {
                            return bitmapResultFactory.wrapDimensionValue(nullValueBitmap);
                        }
                        return bitmapResultFactory.unionDimensionValueBitmaps((Iterable<ImmutableBitmap>)ImmutableList.of((Object)NestedFieldColumnIndexSupplier.this.getBitmap(id), (Object)nullValueBitmap));
                    }
                    if (id < 0) {
                        return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.getBitmap(id));
                }
            };
        }
    }

    private class NestedLongStringValueSetIndex
    implements StringValueSetIndexes {
        private NestedLongStringValueSetIndex() {
        }

        @Override
        public BitmapColumnIndex forValue(@Nullable String value) {
            final boolean inputNull = value == null;
            final Long longValue = GuavaUtils.tryParseLong(value);
            return new SimpleBitmapColumnIndex(){
                final FixedIndexed<Integer> localDictionary;
                final FixedIndexed<Long> longDictionary;
                {
                    this.localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
                    this.longDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.globalLongDictionarySupplier.get();
                }

                @Override
                public int estimatedComputeCost() {
                    return 1;
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
                    if (longValue == null) {
                        if (inputNull) {
                            return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.getBitmap(this.localDictionary.indexOf(0)));
                        }
                        return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    int globalId = this.longDictionary.indexOf(longValue);
                    if (includeUnknown && this.localDictionary.get(0) == 0) {
                        if (globalId < 0) {
                            return bitmapResultFactory.wrapDimensionValue((ImmutableBitmap)NestedFieldColumnIndexSupplier.this.bitmaps.get(0));
                        }
                        return bitmapResultFactory.unionDimensionValueBitmaps((Iterable<ImmutableBitmap>)ImmutableList.of((Object)NestedFieldColumnIndexSupplier.this.getBitmap(this.localDictionary.indexOf(globalId + NestedFieldColumnIndexSupplier.this.adjustLongId)), (Object)((ImmutableBitmap)NestedFieldColumnIndexSupplier.this.bitmaps.get(0))));
                    }
                    if (globalId < 0) {
                        return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.getBitmap(this.localDictionary.indexOf(globalId + NestedFieldColumnIndexSupplier.this.adjustLongId)));
                }
            };
        }

        @Override
        public BitmapColumnIndex forSortedValues(final SortedSet<String> values) {
            return new SimpleImmutableBitmapDelegatingIterableIndex(){

                @Override
                public int estimatedComputeCost() {
                    return values.size();
                }

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    LongArraySet longs = new LongArraySet(values.size());
                    boolean needNullCheck = false;
                    for (String value : values) {
                        if (value == null) {
                            needNullCheck = true;
                            continue;
                        }
                        Long theValue = GuavaUtils.tryParseLong(value);
                        if (theValue == null) continue;
                        longs.add(theValue.longValue());
                    }
                    boolean doNullCheck = needNullCheck;
                    return () -> this.lambda$getBitmapIterable$0((LongSet)longs, doNullCheck);
                }

                @Override
                @Nullable
                @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
                protected ImmutableBitmap getUnknownsBitmap() {
                    if (!values.contains(null) && (Integer)((FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get()).get(0) == 0) {
                        return (ImmutableBitmap)NestedFieldColumnIndexSupplier.this.bitmaps.get(0);
                    }
                    return null;
                }

                private /* synthetic */ Iterator lambda$getBitmapIterable$0(final LongSet longs, final boolean doNullCheck) {
                    return new Iterator<ImmutableBitmap>(){
                        final FixedIndexed<Integer> localDictionary;
                        final FixedIndexed<Long> longDictionary;
                        final LongIterator iterator;
                        int next;
                        boolean nullChecked;
                        {
                            this.localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
                            this.longDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.globalLongDictionarySupplier.get();
                            this.iterator = longs.iterator();
                            this.next = -1;
                            this.nullChecked = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (doNullCheck && !this.nullChecked) {
                                return true;
                            }
                            if (this.next < 0) {
                                this.findNext();
                            }
                            return this.next >= 0;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (doNullCheck && !this.nullChecked) {
                                this.nullChecked = true;
                                return NestedFieldColumnIndexSupplier.this.getBitmap(0);
                            }
                            if (this.next < 0) {
                                this.findNext();
                                if (this.next < 0) {
                                    throw new NoSuchElementException();
                                }
                            }
                            int swap = this.next;
                            this.next = -1;
                            return NestedFieldColumnIndexSupplier.this.getBitmap(swap);
                        }

                        private void findNext() {
                            while (this.next < 0 && this.iterator.hasNext()) {
                                long nextValue = this.iterator.nextLong();
                                this.next = this.localDictionary.indexOf(this.longDictionary.indexOf(nextValue) + NestedFieldColumnIndexSupplier.this.adjustLongId);
                            }
                        }
                    };
                }
            };
        }
    }

    private class NestedLongNumericRangeIndexes
    implements NumericRangeIndexes {
        private NestedLongNumericRangeIndexes() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forRange(@Nullable Number startValue, boolean startStrict, @Nullable Number endValue, boolean endStrict) {
            Long startLong = startValue == null ? null : (startStrict ? Long.valueOf((long)Math.floor(startValue.doubleValue())) : Long.valueOf((long)Math.ceil(startValue.doubleValue())));
            Long endLong = endValue == null ? null : (endStrict ? Long.valueOf((long)Math.ceil(endValue.doubleValue())) : Long.valueOf((long)Math.floor(endValue.doubleValue())));
            return NestedFieldColumnIndexSupplier.this.makeRangeIndex(startLong, startStrict, endLong, endStrict, (Indexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get(), (Indexed)NestedFieldColumnIndexSupplier.this.globalLongDictionarySupplier.get(), NestedFieldColumnIndexSupplier.this.adjustLongId, NestedFieldColumnIndexSupplier.this.columnConfig.skipValueRangeIndexScale());
        }
    }

    private class NestedLongPredicateIndexes
    implements DruidPredicateIndexes {
        private NestedLongPredicateIndexes() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forPredicate(final DruidPredicateFactory matcherFactory) {
            final FixedIndexed localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
            return new DictionaryScanningBitmapIndex(localDictionary.size()){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable(final boolean includeUnknown) {
                    return () -> new Iterator<ImmutableBitmap>(){
                        final FixedIndexed<Long> longDictionary;
                        final DruidLongPredicate longPredicate;
                        final Iterator<Integer> iterator;
                        int index;
                        boolean nextSet;
                        {
                            this.longDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.globalLongDictionarySupplier.get();
                            this.longPredicate = matcherFactory.makeLongPredicate();
                            this.iterator = localDictionary.iterator();
                            this.index = -1;
                            this.nextSet = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (!this.nextSet) {
                                this.findNext();
                            }
                            return this.nextSet;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (!this.nextSet) {
                                this.findNext();
                                if (!this.nextSet) {
                                    throw new NoSuchElementException();
                                }
                            }
                            this.nextSet = false;
                            return NestedFieldColumnIndexSupplier.this.getBitmap(this.index);
                        }

                        private void findNext() {
                            while (!this.nextSet && this.iterator.hasNext()) {
                                Integer nextValue = this.iterator.next();
                                ++this.index;
                                if (nextValue == 0) {
                                    this.nextSet = this.longPredicate.applyNull().matches(includeUnknown);
                                    continue;
                                }
                                this.nextSet = this.longPredicate.applyLong(this.longDictionary.get(nextValue - NestedFieldColumnIndexSupplier.this.adjustLongId)).matches(includeUnknown);
                            }
                        }
                    };
                }
            };
        }
    }

    private class NestedDoubleValueIndexes
    implements ValueIndexes {
        private NestedDoubleValueIndexes() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forValue(@Nonnull Object value, TypeSignature<ValueType> valueType) {
            ImmutableBitmap nullValueBitmap;
            ExprEval<?> eval = ExprEval.ofType(ExpressionType.fromColumnTypeStrict(valueType), value);
            ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(eval, ExpressionType.DOUBLE);
            ImmutableBitmap immutableBitmap = nullValueBitmap = (Integer)((FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get()).get(0) == 0 ? (ImmutableBitmap)NestedFieldColumnIndexSupplier.this.bitmaps.get(0) : NestedFieldColumnIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap();
            if (castForComparison == null) {
                return new AllFalseBitmapColumnIndex(NestedFieldColumnIndexSupplier.this.bitmapFactory, nullValueBitmap);
            }
            final double doubleValue = castForComparison.asDouble();
            return new SimpleBitmapColumnIndex(){
                final FixedIndexed<Integer> localDictionary;
                final FixedIndexed<Double> globalDictionary;
                {
                    this.localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
                    this.globalDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.globalDoubleDictionarySupplier.get();
                }

                @Override
                public int estimatedComputeCost() {
                    return 1;
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
                    int globalId = this.globalDictionary.indexOf(doubleValue);
                    if (globalId < 0) {
                        if (includeUnknown) {
                            return bitmapResultFactory.wrapDimensionValue(nullValueBitmap);
                        }
                        return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    int id = this.localDictionary.indexOf(globalId + NestedFieldColumnIndexSupplier.this.adjustDoubleId);
                    if (includeUnknown) {
                        if (id < 0) {
                            return bitmapResultFactory.wrapDimensionValue(nullValueBitmap);
                        }
                        return bitmapResultFactory.unionDimensionValueBitmaps((Iterable<ImmutableBitmap>)ImmutableList.of((Object)NestedFieldColumnIndexSupplier.this.getBitmap(id), (Object)nullValueBitmap));
                    }
                    if (id < 0) {
                        return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.getBitmap(id));
                }
            };
        }
    }

    private class NestedDoubleStringValueSetIndex
    implements StringValueSetIndexes {
        private NestedDoubleStringValueSetIndex() {
        }

        @Override
        public BitmapColumnIndex forValue(@Nullable String value) {
            final boolean inputNull = value == null;
            final Double doubleValue = Strings.isNullOrEmpty((String)value) ? null : Doubles.tryParse((String)value);
            return new SimpleBitmapColumnIndex(){
                final FixedIndexed<Integer> localDictionary;
                final FixedIndexed<Double> doubleDictionary;
                {
                    this.localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
                    this.doubleDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.globalDoubleDictionarySupplier.get();
                }

                @Override
                public int estimatedComputeCost() {
                    return 1;
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
                    if (doubleValue == null) {
                        if (inputNull) {
                            return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.getBitmap(this.localDictionary.indexOf(0)));
                        }
                        return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    int globalId = this.doubleDictionary.indexOf(doubleValue);
                    if (includeUnknown && this.localDictionary.get(0) == 0) {
                        if (globalId < 0) {
                            return bitmapResultFactory.wrapDimensionValue((ImmutableBitmap)NestedFieldColumnIndexSupplier.this.bitmaps.get(0));
                        }
                        return bitmapResultFactory.unionDimensionValueBitmaps((Iterable<ImmutableBitmap>)ImmutableList.of((Object)NestedFieldColumnIndexSupplier.this.getBitmap(this.localDictionary.indexOf(globalId + NestedFieldColumnIndexSupplier.this.adjustDoubleId)), (Object)((ImmutableBitmap)NestedFieldColumnIndexSupplier.this.bitmaps.get(0))));
                    }
                    if (globalId < 0) {
                        return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.getBitmap(this.localDictionary.indexOf(globalId + NestedFieldColumnIndexSupplier.this.adjustDoubleId)));
                }
            };
        }

        @Override
        public BitmapColumnIndex forSortedValues(final SortedSet<String> values) {
            return new SimpleImmutableBitmapDelegatingIterableIndex(){

                @Override
                public int estimatedComputeCost() {
                    return values.size();
                }

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    DoubleArraySet doubles = new DoubleArraySet(values.size());
                    boolean needNullCheck = false;
                    for (String value : values) {
                        if (value == null) {
                            needNullCheck = true;
                            continue;
                        }
                        Double theValue = Doubles.tryParse((String)value);
                        if (theValue == null) continue;
                        doubles.add(theValue.doubleValue());
                    }
                    boolean doNullCheck = needNullCheck;
                    return () -> this.lambda$getBitmapIterable$0((DoubleSet)doubles, doNullCheck);
                }

                @Override
                @Nullable
                @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
                protected ImmutableBitmap getUnknownsBitmap() {
                    if (!values.contains(null) && (Integer)((FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get()).get(0) == 0) {
                        return (ImmutableBitmap)NestedFieldColumnIndexSupplier.this.bitmaps.get(0);
                    }
                    return null;
                }

                private /* synthetic */ Iterator lambda$getBitmapIterable$0(final DoubleSet doubles, final boolean doNullCheck) {
                    return new Iterator<ImmutableBitmap>(){
                        final FixedIndexed<Integer> localDictionary;
                        final FixedIndexed<Double> doubleDictionary;
                        final DoubleIterator iterator;
                        int next;
                        boolean nullChecked;
                        {
                            this.localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
                            this.doubleDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.globalDoubleDictionarySupplier.get();
                            this.iterator = doubles.iterator();
                            this.next = -1;
                            this.nullChecked = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (doNullCheck && !this.nullChecked) {
                                return true;
                            }
                            if (this.next < 0) {
                                this.findNext();
                            }
                            return this.next >= 0;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (doNullCheck && !this.nullChecked) {
                                this.nullChecked = true;
                                return NestedFieldColumnIndexSupplier.this.getBitmap(0);
                            }
                            if (this.next < 0) {
                                this.findNext();
                                if (this.next < 0) {
                                    throw new NoSuchElementException();
                                }
                            }
                            int swap = this.next;
                            this.next = -1;
                            return NestedFieldColumnIndexSupplier.this.getBitmap(swap);
                        }

                        private void findNext() {
                            while (this.next < 0 && this.iterator.hasNext()) {
                                double nextValue = this.iterator.nextDouble();
                                this.next = this.localDictionary.indexOf(this.doubleDictionary.indexOf(nextValue) + NestedFieldColumnIndexSupplier.this.adjustDoubleId);
                            }
                        }
                    };
                }
            };
        }
    }

    private class NestedDoubleNumericRangeIndexes
    implements NumericRangeIndexes {
        private NestedDoubleNumericRangeIndexes() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forRange(@Nullable Number startValue, boolean startStrict, @Nullable Number endValue, boolean endStrict) {
            return NestedFieldColumnIndexSupplier.this.makeRangeIndex(startValue != null ? Double.valueOf(startValue.doubleValue()) : null, startStrict, endValue != null ? Double.valueOf(endValue.doubleValue()) : null, endStrict, (Indexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get(), (Indexed)NestedFieldColumnIndexSupplier.this.globalDoubleDictionarySupplier.get(), NestedFieldColumnIndexSupplier.this.adjustDoubleId, NestedFieldColumnIndexSupplier.this.columnConfig.skipValueRangeIndexScale());
        }
    }

    private class NestedDoublePredicateIndexes
    implements DruidPredicateIndexes {
        private NestedDoublePredicateIndexes() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forPredicate(final DruidPredicateFactory matcherFactory) {
            FixedIndexed localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
            return new DictionaryScanningBitmapIndex(localDictionary.size()){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable(final boolean includeUnknown) {
                    return () -> new Iterator<ImmutableBitmap>(){
                        final FixedIndexed<Integer> localDictionary;
                        final FixedIndexed<Double> doubleDictionary;
                        final DruidDoublePredicate doublePredicate;
                        final Iterator<Integer> iterator;
                        int index;
                        boolean nextSet;
                        {
                            this.localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
                            this.doubleDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.globalDoubleDictionarySupplier.get();
                            this.doublePredicate = matcherFactory.makeDoublePredicate();
                            this.iterator = this.localDictionary.iterator();
                            this.index = -1;
                            this.nextSet = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (!this.nextSet) {
                                this.findNext();
                            }
                            return this.nextSet;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (!this.nextSet) {
                                this.findNext();
                                if (!this.nextSet) {
                                    throw new NoSuchElementException();
                                }
                            }
                            this.nextSet = false;
                            return NestedFieldColumnIndexSupplier.this.getBitmap(this.index);
                        }

                        private void findNext() {
                            while (!this.nextSet && this.iterator.hasNext()) {
                                Integer nextValue = this.iterator.next();
                                ++this.index;
                                if (nextValue == 0) {
                                    this.nextSet = this.doublePredicate.applyNull().matches(includeUnknown);
                                    continue;
                                }
                                this.nextSet = this.doublePredicate.applyDouble(this.doubleDictionary.get(nextValue - NestedFieldColumnIndexSupplier.this.adjustDoubleId)).matches(includeUnknown);
                            }
                        }
                    };
                }
            };
        }
    }

    private class NestedArrayValueIndexes
    implements ValueIndexes {
        private final ImmutableBitmap nullValueBitmap;

        private NestedArrayValueIndexes() {
            this.nullValueBitmap = (Integer)((FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get()).get(0) == 0 ? (ImmutableBitmap)NestedFieldColumnIndexSupplier.this.bitmaps.get(0) : NestedFieldColumnIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap();
        }

        @Override
        @Nullable
        public BitmapColumnIndex forValue(@Nonnull Object value, TypeSignature<ValueType> valueType) {
            int elementOffset;
            Indexed elements;
            if (!valueType.isArray()) {
                return new AllFalseBitmapColumnIndex(NestedFieldColumnIndexSupplier.this.bitmapFactory, this.nullValueBitmap);
            }
            ExprEval<?> eval = ExprEval.ofType(ExpressionType.fromColumnTypeStrict(valueType), value);
            ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(eval, ExpressionType.fromColumnTypeStrict(NestedFieldColumnIndexSupplier.this.singleType));
            if (castForComparison == null) {
                return new AllFalseBitmapColumnIndex(NestedFieldColumnIndexSupplier.this.bitmapFactory, this.nullValueBitmap);
            }
            Object[] arrayToMatch = castForComparison.asArray();
            switch ((ValueType)NestedFieldColumnIndexSupplier.this.singleType.getElementType().getType()) {
                case STRING: {
                    elements = (Indexed)NestedFieldColumnIndexSupplier.this.globalStringDictionarySupplier.get();
                    elementOffset = 0;
                    break;
                }
                case LONG: {
                    elements = (Indexed)NestedFieldColumnIndexSupplier.this.globalLongDictionarySupplier.get();
                    elementOffset = NestedFieldColumnIndexSupplier.this.adjustLongId;
                    break;
                }
                case DOUBLE: {
                    elements = (Indexed)NestedFieldColumnIndexSupplier.this.globalDoubleDictionarySupplier.get();
                    elementOffset = NestedFieldColumnIndexSupplier.this.adjustDoubleId;
                    break;
                }
                default: {
                    throw DruidException.defensive("Unhandled array type [%s] how did this happen?", NestedFieldColumnIndexSupplier.this.singleType.getElementType());
                }
            }
            final int[] ids = new int[arrayToMatch.length];
            for (int i = 0; i < arrayToMatch.length; ++i) {
                ids[i] = arrayToMatch[i] == null ? 0 : (NestedFieldColumnIndexSupplier.this.singleType.getElementType().is(ValueType.STRING) ? elements.indexOf(StringUtils.toUtf8ByteBuffer((String)arrayToMatch[i])) : elements.indexOf(arrayToMatch[i]) + elementOffset);
                if (ids[i] >= 0 || value != null) continue;
                return new AllFalseBitmapColumnIndex(NestedFieldColumnIndexSupplier.this.bitmapFactory, this.nullValueBitmap);
            }
            final FixedIndexed localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
            final FrontCodedIntArrayIndexed globalArrayDictionary = (FrontCodedIntArrayIndexed)NestedFieldColumnIndexSupplier.this.globalArrayDictionarySupplier.get();
            return new SimpleBitmapColumnIndex(){

                @Override
                public int estimatedComputeCost() {
                    return 1;
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
                    int localId = localDictionary.indexOf(globalArrayDictionary.indexOf(ids) + NestedFieldColumnIndexSupplier.this.adjustArrayId);
                    if (includeUnknown) {
                        if (localId < 0) {
                            return bitmapResultFactory.wrapDimensionValue(NestedArrayValueIndexes.this.nullValueBitmap);
                        }
                        return bitmapResultFactory.unionDimensionValueBitmaps((Iterable<ImmutableBitmap>)ImmutableList.of((Object)NestedFieldColumnIndexSupplier.this.getBitmap(localId), (Object)NestedArrayValueIndexes.this.nullValueBitmap));
                    }
                    if (localId < 0) {
                        return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.getBitmap(localId));
                }
            };
        }
    }

    private class NestedArrayElementIndexes
    implements ArrayElementIndexes {
        private final ImmutableBitmap nullValueBitmap;

        private NestedArrayElementIndexes() {
            this.nullValueBitmap = (Integer)((FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get()).get(0) == 0 ? (ImmutableBitmap)NestedFieldColumnIndexSupplier.this.bitmaps.get(0) : NestedFieldColumnIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap();
        }

        @Override
        @Nullable
        public BitmapColumnIndex containsValue(@Nullable Object value, TypeSignature<ValueType> elementValueType) {
            int elementOffset;
            Indexed globalElements;
            if (elementValueType.isArray()) {
                return new AllFalseBitmapColumnIndex(NestedFieldColumnIndexSupplier.this.bitmapFactory, this.nullValueBitmap);
            }
            ExprEval<?> eval = ExprEval.ofType(ExpressionType.fromColumnTypeStrict(elementValueType), value);
            final ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(eval, ExpressionType.fromColumnTypeStrict(NestedFieldColumnIndexSupplier.this.singleType.isArray() ? NestedFieldColumnIndexSupplier.this.singleType.getElementType() : NestedFieldColumnIndexSupplier.this.singleType));
            if (castForComparison == null) {
                return new AllFalseBitmapColumnIndex(NestedFieldColumnIndexSupplier.this.bitmapFactory, this.nullValueBitmap);
            }
            final FixedIndexed elementDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.arrayElementDictionarySupplier.get();
            switch ((ValueType)NestedFieldColumnIndexSupplier.this.singleType.getElementType().getType()) {
                case STRING: {
                    globalElements = (Indexed)NestedFieldColumnIndexSupplier.this.globalStringDictionarySupplier.get();
                    elementOffset = 0;
                    break;
                }
                case LONG: {
                    globalElements = (Indexed)NestedFieldColumnIndexSupplier.this.globalLongDictionarySupplier.get();
                    elementOffset = NestedFieldColumnIndexSupplier.this.adjustLongId;
                    break;
                }
                case DOUBLE: {
                    globalElements = (Indexed)NestedFieldColumnIndexSupplier.this.globalDoubleDictionarySupplier.get();
                    elementOffset = NestedFieldColumnIndexSupplier.this.adjustDoubleId;
                    break;
                }
                default: {
                    throw DruidException.defensive("Unhandled array type [%s] how did this happen?", NestedFieldColumnIndexSupplier.this.singleType.getElementType());
                }
            }
            return new SimpleBitmapColumnIndex(){

                @Override
                public int estimatedComputeCost() {
                    return 1;
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
                    int elementId = this.getElementId();
                    if (includeUnknown) {
                        if (elementId < 0) {
                            return bitmapResultFactory.wrapDimensionValue(NestedArrayElementIndexes.this.nullValueBitmap);
                        }
                        return bitmapResultFactory.unionDimensionValueBitmaps((Iterable<ImmutableBitmap>)ImmutableList.of((Object)this.getElementBitmap(elementId), (Object)NestedArrayElementIndexes.this.nullValueBitmap));
                    }
                    if (elementId < 0) {
                        return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    return bitmapResultFactory.wrapDimensionValue(this.getElementBitmap(elementId));
                }

                private int getElementId() {
                    if (castForComparison.value() == null) {
                        return 0;
                    }
                    if (castForComparison.type().is(ExprType.STRING)) {
                        return elementDictionary.indexOf(globalElements.indexOf(StringUtils.toUtf8ByteBuffer(castForComparison.asString())));
                    }
                    return elementDictionary.indexOf(globalElements.indexOf(castForComparison.value()) + elementOffset);
                }

                private ImmutableBitmap getElementBitmap(int idx) {
                    if (idx < 0) {
                        return NestedFieldColumnIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap();
                    }
                    ImmutableBitmap bitmap = (ImmutableBitmap)NestedFieldColumnIndexSupplier.this.arrayElementBitmaps.get(idx);
                    return bitmap == null ? NestedFieldColumnIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap() : bitmap;
                }
            };
        }
    }

    private class NestedVariantStringValueSetIndexes
    extends NestedVariantIndexes
    implements StringValueSetIndexes {
        private NestedVariantStringValueSetIndexes() {
        }

        @Override
        public BitmapColumnIndex forValue(final @Nullable String value) {
            return new SimpleImmutableBitmapDelegatingIterableIndex(){

                @Override
                public int estimatedComputeCost() {
                    return 3;
                }

                @Override
                protected Iterable<ImmutableBitmap> getBitmapIterable() {
                    IntListIterator iterator = NestedVariantStringValueSetIndexes.this.getIndexes(value).iterator();
                    return () -> this.lambda$getBitmapIterable$0((IntIterator)iterator);
                }

                @Override
                @Nullable
                protected ImmutableBitmap getUnknownsBitmap() {
                    if (value != null && (Integer)((FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get()).get(0) == 0) {
                        return (ImmutableBitmap)NestedFieldColumnIndexSupplier.this.bitmaps.get(0);
                    }
                    return null;
                }

                private /* synthetic */ Iterator lambda$getBitmapIterable$0(final IntIterator iterator) {
                    return new Iterator<ImmutableBitmap>(){

                        @Override
                        public boolean hasNext() {
                            return iterator.hasNext();
                        }

                        @Override
                        public ImmutableBitmap next() {
                            return NestedFieldColumnIndexSupplier.this.getBitmap(iterator.nextInt());
                        }
                    };
                }
            };
        }

        @Override
        public BitmapColumnIndex forSortedValues(final SortedSet<String> values) {
            return new SimpleImmutableBitmapDelegatingIterableIndex(){

                @Override
                public int estimatedComputeCost() {
                    if (values.size() >= 0x2AAAAAAA) {
                        return Integer.MAX_VALUE;
                    }
                    return values.size() * 3;
                }

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        final Iterator<String> iterator;
                        IntIterator nextIterator;
                        {
                            this.iterator = values.iterator();
                            this.nextIterator = null;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.nextIterator == null || !this.nextIterator.hasNext()) {
                                this.findNext();
                            }
                            return this.nextIterator.hasNext();
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (this.nextIterator == null || !this.nextIterator.hasNext()) {
                                this.findNext();
                                if (!this.nextIterator.hasNext()) {
                                    throw new NoSuchElementException();
                                }
                            }
                            return NestedFieldColumnIndexSupplier.this.getBitmap(this.nextIterator.nextInt());
                        }

                        private void findNext() {
                            while ((this.nextIterator == null || !this.nextIterator.hasNext()) && this.iterator.hasNext()) {
                                String nextValue = this.iterator.next();
                                this.nextIterator = NestedVariantStringValueSetIndexes.this.getIndexes(nextValue).iterator();
                            }
                        }
                    };
                }

                @Override
                @Nullable
                @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
                protected ImmutableBitmap getUnknownsBitmap() {
                    if (!values.contains(null) && (Integer)((FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get()).get(0) == 0) {
                        return (ImmutableBitmap)NestedFieldColumnIndexSupplier.this.bitmaps.get(0);
                    }
                    return null;
                }
            };
        }
    }

    private class NestedVariantPredicateIndexes
    extends NestedVariantIndexes
    implements DruidPredicateIndexes {
        private NestedVariantPredicateIndexes() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forPredicate(final DruidPredicateFactory matcherFactory) {
            return new DictionaryScanningBitmapIndex(this.localDictionary.size()){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable(final boolean includeUnknown) {
                    return () -> new Iterator<ImmutableBitmap>(){
                        final DruidObjectPredicate<String> stringPredicate;
                        final DruidLongPredicate longPredicate;
                        final DruidDoublePredicate doublePredicate;
                        final Supplier<DruidObjectPredicate<Object[]>> arrayPredicateSupplier;
                        final Iterator<Integer> iterator;
                        int index;
                        boolean nextSet;
                        {
                            this.stringPredicate = matcherFactory.makeStringPredicate();
                            this.longPredicate = matcherFactory.makeLongPredicate();
                            this.doublePredicate = matcherFactory.makeDoublePredicate();
                            this.arrayPredicateSupplier = Suppliers.memoize(() -> matcherFactory.makeArrayPredicate(NestedFieldColumnIndexSupplier.this.singleType));
                            this.iterator = NestedVariantPredicateIndexes.this.localDictionary.iterator();
                            this.index = -1;
                            this.nextSet = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (!this.nextSet) {
                                this.findNext();
                            }
                            return this.nextSet;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (!this.nextSet) {
                                this.findNext();
                                if (!this.nextSet) {
                                    throw new NoSuchElementException();
                                }
                            }
                            this.nextSet = false;
                            return NestedFieldColumnIndexSupplier.this.getBitmap(this.index);
                        }

                        private void findNext() {
                            while (!this.nextSet && this.iterator.hasNext()) {
                                Integer nextValue = this.iterator.next();
                                ++this.index;
                                if (nextValue >= NestedFieldColumnIndexSupplier.this.adjustArrayId) {
                                    Preconditions.checkNotNull((Object)NestedVariantPredicateIndexes.this.arrayDictionary);
                                    int[] array = NestedVariantPredicateIndexes.this.arrayDictionary.get(nextValue - NestedFieldColumnIndexSupplier.this.adjustArrayId);
                                    Object[] arrayObj = new Object[array.length];
                                    for (int i = 0; i < arrayObj.length; ++i) {
                                        arrayObj[i] = array[i] == 0 ? null : (array[i] >= NestedFieldColumnIndexSupplier.this.adjustDoubleId ? NestedVariantPredicateIndexes.this.doubleDictionary.get(array[i] - NestedFieldColumnIndexSupplier.this.adjustDoubleId) : (array[i] >= NestedFieldColumnIndexSupplier.this.adjustLongId ? NestedVariantPredicateIndexes.this.longDictionary.get(array[i] - NestedFieldColumnIndexSupplier.this.adjustLongId) : StringUtils.fromUtf8Nullable((ByteBuffer)NestedVariantPredicateIndexes.this.stringDictionary.get(array[i]))));
                                    }
                                    this.nextSet = ((DruidObjectPredicate)this.arrayPredicateSupplier.get()).apply(arrayObj).matches(includeUnknown);
                                    continue;
                                }
                                if (nextValue >= NestedFieldColumnIndexSupplier.this.adjustDoubleId) {
                                    this.nextSet = this.doublePredicate.applyDouble((Double)NestedVariantPredicateIndexes.this.doubleDictionary.get(nextValue - NestedFieldColumnIndexSupplier.this.adjustDoubleId)).matches(includeUnknown);
                                    continue;
                                }
                                if (nextValue >= NestedFieldColumnIndexSupplier.this.adjustLongId) {
                                    this.nextSet = this.longPredicate.applyLong((Long)NestedVariantPredicateIndexes.this.longDictionary.get(nextValue - NestedFieldColumnIndexSupplier.this.adjustLongId)).matches(includeUnknown);
                                    continue;
                                }
                                this.nextSet = this.stringPredicate.apply(StringUtils.fromUtf8Nullable((ByteBuffer)NestedVariantPredicateIndexes.this.stringDictionary.get(nextValue))).matches(includeUnknown);
                            }
                        }
                    };
                }
            };
        }
    }

    private abstract class NestedVariantIndexes {
        final FixedIndexed<Integer> localDictionary;
        final Indexed<ByteBuffer> stringDictionary;
        final FixedIndexed<Long> longDictionary;
        final FixedIndexed<Double> doubleDictionary;
        @Nullable
        final FrontCodedIntArrayIndexed arrayDictionary;
        static final int INDEX_COMPUTE_SCALE = 3;

        private NestedVariantIndexes() {
            this.localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
            this.stringDictionary = (Indexed)NestedFieldColumnIndexSupplier.this.globalStringDictionarySupplier.get();
            this.longDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.globalLongDictionarySupplier.get();
            this.doubleDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.globalDoubleDictionarySupplier.get();
            this.arrayDictionary = NestedFieldColumnIndexSupplier.this.globalArrayDictionarySupplier == null ? null : (FrontCodedIntArrayIndexed)NestedFieldColumnIndexSupplier.this.globalArrayDictionarySupplier.get();
        }

        IntList getIndexes(@Nullable String value) {
            int localId;
            Double someDouble;
            int localId2;
            Long someLong;
            int localId3;
            IntArrayList intList = new IntArrayList();
            if (value == null) {
                intList.add(this.localDictionary.indexOf(0));
                return intList;
            }
            int globalId = this.stringDictionary.indexOf(StringUtils.toUtf8ByteBuffer(value));
            if (globalId >= 0 && (localId3 = this.localDictionary.indexOf(globalId)) >= 0) {
                intList.add(localId3);
            }
            if ((someLong = GuavaUtils.tryParseLong(value)) != null && (globalId = this.longDictionary.indexOf(someLong)) >= 0 && (localId2 = this.localDictionary.indexOf(globalId + NestedFieldColumnIndexSupplier.this.adjustLongId)) >= 0) {
                intList.add(localId2);
            }
            if ((someDouble = Doubles.tryParse((String)value)) != null && (globalId = this.doubleDictionary.indexOf(someDouble)) >= 0 && (localId = this.localDictionary.indexOf(globalId + NestedFieldColumnIndexSupplier.this.adjustDoubleId)) >= 0) {
                intList.add(localId);
            }
            return intList;
        }
    }
}

