/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.LongSupplier;
import javax.annotation.Nullable;
import net.jpountz.xxhash.XXHash64;
import net.jpountz.xxhash.XXHashFactory;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.segment.column.TypeStrategies;
import org.apache.druid.segment.serde.ColumnSerializerUtils;

public class StructuredData
implements Comparable<StructuredData> {
    private static final XXHash64 HASH_FUNCTION = XXHashFactory.fastestInstance().hash64();
    private static int SEED = -1756908916;
    public static final Comparator<StructuredData> COMPARATOR = Comparators.naturalNullsFirst();
    private static final ObjectWriter WRITER = ColumnSerializerUtils.SMILE_MAPPER.writer(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
    private final Object value;
    private volatile boolean hashInitialized = false;
    private volatile long hashValue;
    private volatile int sizeEstimate = -1;
    private final LongSupplier hash = () -> {
        if (!this.hashInitialized) {
            byte[] bytes = StructuredData.serialized(this);
            this.sizeEstimate = bytes.length + 4;
            this.hashValue = HASH_FUNCTION.hash(bytes, 0, bytes.length, (long)SEED);
            this.hashInitialized = true;
        }
        return this.hashValue;
    };

    private static byte[] serialized(StructuredData data) {
        try {
            return WRITER.writeValueAsBytes(data.value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static StructuredData wrap(@Nullable Object value) {
        if (value == null || value instanceof StructuredData) {
            return (StructuredData)value;
        }
        return new StructuredData(value);
    }

    @Nullable
    public static Object unwrap(@Nullable Object value) {
        if (value instanceof StructuredData) {
            return ((StructuredData)value).getValue();
        }
        return value;
    }

    @JsonCreator
    public static StructuredData create(Object value) {
        return new StructuredData(value);
    }

    public StructuredData(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    private boolean isNull() {
        return this.value == null;
    }

    private boolean isString() {
        return this.value instanceof String;
    }

    private boolean isNumber() {
        return this.value instanceof Number;
    }

    private String asString() {
        return (String)this.value;
    }

    private Number asNumber() {
        return (Number)this.value;
    }

    public int getSizeEstimate() {
        if (this.sizeEstimate < 0) {
            this.hash.getAsLong();
        }
        Preconditions.checkState((this.sizeEstimate >= 0 ? 1 : 0) != 0, (Object)"sizeEstimate not initialized");
        return this.sizeEstimate;
    }

    @Override
    public int compareTo(StructuredData o) {
        if (this.equals(o)) {
            return 0;
        }
        if (this.isNull()) {
            return -1;
        }
        if (o.isNull()) {
            return 1;
        }
        if (this.isString()) {
            if (o.isString()) {
                return TypeStrategies.STRING.compare(this.asString(), o.asString());
            }
            return -1;
        }
        if (o.isString()) {
            return 1;
        }
        if (this.isNumber()) {
            if (o.isNumber()) {
                return TypeStrategies.DOUBLE.compare((Object)this.asNumber().doubleValue(), (Object)o.asNumber().doubleValue());
            }
            return -1;
        }
        if (o.isNumber()) {
            return 1;
        }
        return Long.compare(this.hash.getAsLong(), o.hash.getAsLong());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StructuredData that = (StructuredData)o;
        if (this.value instanceof Object[] && that.value instanceof Object[]) {
            return Arrays.deepEquals((Object[])this.value, (Object[])that.value);
        }
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Longs.hashCode((long)this.hash.getAsLong());
    }

    public String toString() {
        return "StructuredData{value=" + String.valueOf(this.value) + "}";
    }
}

