/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.BitmapSerde;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.CompressedColumnarFloatsSupplier;
import org.apache.druid.segment.file.SegmentFileBuilder;
import org.apache.druid.segment.serde.ColumnPartSerde;
import org.apache.druid.segment.serde.FloatNumericColumnSupplier;
import org.apache.druid.segment.serde.Serializer;

public class FloatNumericColumnPartSerdeV2
implements ColumnPartSerde {
    private final ByteOrder byteOrder;
    @Nullable
    private final Serializer serializer;
    private final BitmapSerdeFactory bitmapSerdeFactory;

    @JsonCreator
    public static FloatNumericColumnPartSerdeV2 createDeserializer(@JsonProperty(value="byteOrder") ByteOrder byteOrder, @JsonProperty(value="bitmapSerdeFactory") @Nullable BitmapSerdeFactory bitmapSerdeFactory) {
        return new FloatNumericColumnPartSerdeV2(byteOrder, bitmapSerdeFactory != null ? bitmapSerdeFactory : new BitmapSerde.LegacyBitmapSerdeFactory(), null);
    }

    private FloatNumericColumnPartSerdeV2(ByteOrder byteOrder, BitmapSerdeFactory bitmapSerdeFactory, @Nullable Serializer serializer) {
        this.byteOrder = byteOrder;
        this.bitmapSerdeFactory = bitmapSerdeFactory;
        this.serializer = serializer;
    }

    @JsonProperty
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @JsonProperty
    public BitmapSerdeFactory getBitmapSerdeFactory() {
        return this.bitmapSerdeFactory;
    }

    public static SerializerBuilder serializerBuilder() {
        return new SerializerBuilder();
    }

    @Override
    @Nullable
    public Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public ColumnPartSerde.Deserializer getDeserializer() {
        return (buffer, builder, columnConfig, parent) -> {
            boolean hasNulls;
            ImmutableBitmap bitmap;
            int offset = buffer.getInt();
            int initialPos = buffer.position();
            CompressedColumnarFloatsSupplier column = CompressedColumnarFloatsSupplier.fromByteBuffer(buffer, this.byteOrder, builder.getFileMapper());
            buffer.position(initialPos + offset);
            if (buffer.hasRemaining()) {
                bitmap = this.bitmapSerdeFactory.getObjectStrategy().fromByteBufferWithSize(buffer);
                hasNulls = !bitmap.isEmpty();
            } else {
                bitmap = this.bitmapSerdeFactory.getBitmapFactory().makeEmptyImmutableBitmap();
                hasNulls = false;
            }
            builder.setType(ValueType.FLOAT).setHasMultipleValues(false).setHasNulls(hasNulls).setNumericColumnSupplier(new FloatNumericColumnSupplier(column, bitmap)).setNullValueIndexSupplier(bitmap);
        };
    }

    public static class SerializerBuilder {
        @Nullable
        private ByteOrder byteOrder = null;
        @Nullable
        private Serializer delegate = null;
        @Nullable
        private BitmapSerdeFactory bitmapSerdeFactory = null;

        public SerializerBuilder withByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public SerializerBuilder withDelegate(Serializer delegate) {
            this.delegate = delegate;
            return this;
        }

        public SerializerBuilder withBitmapSerdeFactory(BitmapSerdeFactory bitmapSerdeFactory) {
            this.bitmapSerdeFactory = bitmapSerdeFactory;
            return this;
        }

        public FloatNumericColumnPartSerdeV2 build() {
            Serializer serializer = new Serializer(){

                @Override
                public long getSerializedSize() throws IOException {
                    return delegate.getSerializedSize();
                }

                @Override
                public void writeTo(WritableByteChannel channel, SegmentFileBuilder fileSmoosher) throws IOException {
                    delegate.writeTo(channel, fileSmoosher);
                }
            };
            return new FloatNumericColumnPartSerdeV2(this.byteOrder, this.bitmapSerdeFactory, serializer);
        }
    }
}

