/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.worker;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.discovery.DataServerClient;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.msq.counters.ChannelCounters;
import org.apache.druid.msq.exec.DataServerQueryHandler;
import org.apache.druid.msq.exec.DataServerQueryHandlerUtils;
import org.apache.druid.msq.exec.DataServerQueryResult;
import org.apache.druid.msq.input.table.DataServerRequestDescriptor;
import org.apache.druid.msq.input.table.RichSegmentDescriptor;
import org.apache.druid.query.Queries;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.aggregation.MetricManipulatorFns;
import org.apache.druid.query.context.DefaultResponseContext;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceLocation;
import org.apache.druid.server.coordination.DruidServerMetadata;

public class DartDataServerQueryHandler
implements DataServerQueryHandler {
    private final int inputNumber;
    private final String dataSourceName;
    private final ChannelCounters channelCounters;
    private final ServiceClientFactory serviceClientFactory;
    private final ObjectMapper objectMapper;
    private final QueryToolChestWarehouse warehouse;
    private final DataServerRequestDescriptor requestDescriptor;

    public DartDataServerQueryHandler(int inputNumber, String dataSourceName, ChannelCounters channelCounters, ServiceClientFactory serviceClientFactory, ObjectMapper objectMapper, QueryToolChestWarehouse warehouse, DataServerRequestDescriptor requestDescriptor) {
        this.inputNumber = inputNumber;
        this.dataSourceName = dataSourceName;
        this.channelCounters = channelCounters;
        this.serviceClientFactory = serviceClientFactory;
        this.objectMapper = objectMapper;
        this.warehouse = warehouse;
        this.requestDescriptor = requestDescriptor;
    }

    @Override
    public <RowType, QueryType> ListenableFuture<DataServerQueryResult<RowType>> fetchRowsFromDataServer(Query<QueryType> query, java.util.function.Function<Sequence<QueryType>, Sequence<RowType>> mappingFunction, Closer closer) {
        Query preparedQuery = Queries.withSpecificSegments(DataServerQueryHandlerUtils.prepareQuery(query, this.inputNumber, this.dataSourceName), this.requestDescriptor.getSegments().stream().map(RichSegmentDescriptor::toPlainDescriptor).collect(Collectors.toList()));
        ServiceLocation serviceLocation = ServiceLocation.fromDruidServerMetadata((DruidServerMetadata)this.requestDescriptor.getServerMetadata());
        DataServerClient dataServerClient = this.makeDataServerClient(serviceLocation);
        QueryToolChest toolChest = this.warehouse.getToolChest(query);
        Function preComputeManipulatorFn = toolChest.makePreComputeManipulatorFn(query, MetricManipulatorFns.deserializing());
        JavaType queryResultType = toolChest.getBaseResultType();
        DefaultResponseContext responseContext = new DefaultResponseContext();
        return FutureUtils.transform((ListenableFuture)dataServerClient.run(preparedQuery, (ResponseContext)responseContext, queryResultType, closer), arg_0 -> this.lambda$fetchRowsFromDataServer$0((java.util.function.Function)preComputeManipulatorFn, mappingFunction, (ResponseContext)responseContext, serviceLocation, arg_0));
    }

    private DataServerClient makeDataServerClient(ServiceLocation serviceLocation) {
        return new DataServerClient(this.serviceClientFactory, serviceLocation, this.objectMapper);
    }

    private /* synthetic */ DataServerQueryResult lambda$fetchRowsFromDataServer$0(java.util.function.Function preComputeManipulatorFn, java.util.function.Function mappingFunction, ResponseContext responseContext, ServiceLocation serviceLocation, Sequence resultSequence) {
        Yielder yielder = DataServerQueryHandlerUtils.createYielder(resultSequence.map(preComputeManipulatorFn), mappingFunction, this.channelCounters);
        List<SegmentDescriptor> missingSegments = DataServerQueryHandlerUtils.getMissingSegments(responseContext);
        if (!missingSegments.isEmpty()) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.RUNTIME_FAILURE).build("Segment[%s]%s not found on server[%s]. Please retry your query.", new Object[]{missingSegments.get(0), missingSegments.size() > 1 ? StringUtils.format((String)" and[%d] others", (Object[])new Object[]{missingSegments.size() - 1}) : "", serviceLocation.getHostAndPort()});
        }
        return new DataServerQueryResult(Collections.singletonList(yielder), Collections.emptyList(), this.dataSourceName);
    }
}

