/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.worker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordination.DruidServerMetadata;

public class WorkerId {
    private static final Pattern PATTERN = Pattern.compile("^(\\w+):(.+:\\d+):([a-z0-9-]+)$");
    private final String scheme;
    private final String hostAndPort;
    private final String queryId;
    private final String fullString;

    public WorkerId(String scheme, String hostAndPort, String queryId) {
        this.scheme = (String)Preconditions.checkNotNull((Object)scheme, (Object)"scheme");
        this.hostAndPort = (String)Preconditions.checkNotNull((Object)hostAndPort, (Object)"hostAndPort");
        this.queryId = (String)Preconditions.checkNotNull((Object)queryId, (Object)"queryId");
        this.fullString = Joiner.on((char)':').join((Object)scheme, (Object)hostAndPort, new Object[]{queryId});
    }

    @JsonCreator
    public static WorkerId fromString(String s) {
        if (s == null) {
            throw new IAE("Missing workerId", new Object[0]);
        }
        Matcher matcher = PATTERN.matcher(s);
        if (matcher.matches()) {
            return new WorkerId(matcher.group(1), matcher.group(2), matcher.group(3));
        }
        throw new IAE("Invalid workerId[%s]", new Object[]{s});
    }

    public static WorkerId fromDruidNode(DruidNode node, String queryId) {
        return new WorkerId(node.getServiceScheme(), node.getHostAndPortToUse(), queryId);
    }

    public static WorkerId fromDruidServerMetadata(DruidServerMetadata server, String queryId) {
        return new WorkerId(server.getHostAndTlsPort() != null ? "https" : "http", server.getHost(), queryId);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHostAndPort() {
        return this.hostAndPort;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public URI toUri() {
        try {
            String path = StringUtils.format((String)"%s/workers/%s", (Object[])new Object[]{"/druid/dart-worker", StringUtils.urlEncode((String)this.queryId)});
            return new URI(this.scheme, this.hostAndPort, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @JsonValue
    public String toString() {
        return this.fullString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerId workerId = (WorkerId)o;
        return Objects.equals(this.fullString, workerId.fullString);
    }

    public int hashCode() {
        return this.fullString.hashCode();
    }
}

