/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class CreateDelegationTokenResponseData
implements ApiMessage {
    short errorCode;
    String principalType;
    String principalName;
    long issueTimestampMs;
    long expiryTimestampMs;
    long maxTimestampMs;
    String tokenId;
    byte[] hmac;
    int throttleTimeMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public CreateDelegationTokenResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public CreateDelegationTokenResponseData() {
        this.errorCode = 0;
        this.principalType = "";
        this.principalName = "";
        this.issueTimestampMs = 0L;
        this.expiryTimestampMs = 0L;
        this.maxTimestampMs = 0L;
        this.tokenId = "";
        this.hmac = Bytes.EMPTY;
        this.throttleTimeMs = 0;
    }

    @Override
    public short apiKey() {
        return 38;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.errorCode = _readable.readShort();
        int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field principalType was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field principalType had invalid length " + length);
        }
        this.principalType = _readable.readString(length);
        length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field principalName was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field principalName had invalid length " + length);
        }
        this.principalName = _readable.readString(length);
        this.issueTimestampMs = _readable.readLong();
        this.expiryTimestampMs = _readable.readLong();
        this.maxTimestampMs = _readable.readLong();
        length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field tokenId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field tokenId had invalid length " + length);
        }
        this.tokenId = _readable.readString(length);
        length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
        if (length < 0) {
            throw new RuntimeException("non-nullable field hmac was serialized as null");
        }
        byte[] newBytes = _readable.readArray(length);
        this.hmac = newBytes;
        this.throttleTimeMs = _readable.readInt();
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeShort(this.errorCode);
        byte[] _stringBytes = _cache.getSerializedValue(this.principalType);
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
        } else {
            _writable.writeShort((short)_stringBytes.length);
        }
        _writable.writeByteArray(_stringBytes);
        _stringBytes = _cache.getSerializedValue(this.principalName);
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
        } else {
            _writable.writeShort((short)_stringBytes.length);
        }
        _writable.writeByteArray(_stringBytes);
        _writable.writeLong(this.issueTimestampMs);
        _writable.writeLong(this.expiryTimestampMs);
        _writable.writeLong(this.maxTimestampMs);
        _stringBytes = _cache.getSerializedValue(this.tokenId);
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
        } else {
            _writable.writeShort((short)_stringBytes.length);
        }
        _writable.writeByteArray(_stringBytes);
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.hmac.length + 1);
        } else {
            _writable.writeInt(this.hmac.length);
        }
        _writable.writeByteArray(this.hmac);
        _writable.writeInt(this.throttleTimeMs);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(2);
        byte[] _stringBytes = this.principalType.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'principalType' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.principalType, _stringBytes);
        if (_version >= 2) {
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        } else {
            _size.addBytes(_stringBytes.length + 2);
        }
        _stringBytes = this.principalName.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'principalName' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.principalName, _stringBytes);
        if (_version >= 2) {
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        } else {
            _size.addBytes(_stringBytes.length + 2);
        }
        _size.addBytes(8);
        _size.addBytes(8);
        _size.addBytes(8);
        _stringBytes = this.tokenId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'tokenId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.tokenId, _stringBytes);
        if (_version >= 2) {
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        } else {
            _size.addBytes(_stringBytes.length + 2);
        }
        _size.addBytes(this.hmac.length);
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.hmac.length + 1));
        } else {
            _size.addBytes(4);
        }
        _size.addBytes(4);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CreateDelegationTokenResponseData)) {
            return false;
        }
        CreateDelegationTokenResponseData other = (CreateDelegationTokenResponseData)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.principalType == null ? other.principalType != null : !this.principalType.equals(other.principalType)) {
            return false;
        }
        if (this.principalName == null ? other.principalName != null : !this.principalName.equals(other.principalName)) {
            return false;
        }
        if (this.issueTimestampMs != other.issueTimestampMs) {
            return false;
        }
        if (this.expiryTimestampMs != other.expiryTimestampMs) {
            return false;
        }
        if (this.maxTimestampMs != other.maxTimestampMs) {
            return false;
        }
        if (this.tokenId == null ? other.tokenId != null : !this.tokenId.equals(other.tokenId)) {
            return false;
        }
        if (!Arrays.equals(this.hmac, other.hmac)) {
            return false;
        }
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.principalType == null ? 0 : this.principalType.hashCode());
        hashCode = 31 * hashCode + (this.principalName == null ? 0 : this.principalName.hashCode());
        hashCode = 31 * hashCode + ((int)(this.issueTimestampMs >> 32) ^ (int)this.issueTimestampMs);
        hashCode = 31 * hashCode + ((int)(this.expiryTimestampMs >> 32) ^ (int)this.expiryTimestampMs);
        hashCode = 31 * hashCode + ((int)(this.maxTimestampMs >> 32) ^ (int)this.maxTimestampMs);
        hashCode = 31 * hashCode + (this.tokenId == null ? 0 : this.tokenId.hashCode());
        hashCode = 31 * hashCode + Arrays.hashCode(this.hmac);
        hashCode = 31 * hashCode + this.throttleTimeMs;
        return hashCode;
    }

    @Override
    public CreateDelegationTokenResponseData duplicate() {
        CreateDelegationTokenResponseData _duplicate = new CreateDelegationTokenResponseData();
        _duplicate.errorCode = this.errorCode;
        _duplicate.principalType = this.principalType;
        _duplicate.principalName = this.principalName;
        _duplicate.issueTimestampMs = this.issueTimestampMs;
        _duplicate.expiryTimestampMs = this.expiryTimestampMs;
        _duplicate.maxTimestampMs = this.maxTimestampMs;
        _duplicate.tokenId = this.tokenId;
        _duplicate.hmac = MessageUtil.duplicate(this.hmac);
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        return _duplicate;
    }

    public String toString() {
        return "CreateDelegationTokenResponseData(errorCode=" + this.errorCode + ", principalType=" + (this.principalType == null ? "null" : "'" + this.principalType.toString() + "'") + ", principalName=" + (this.principalName == null ? "null" : "'" + this.principalName.toString() + "'") + ", issueTimestampMs=" + this.issueTimestampMs + ", expiryTimestampMs=" + this.expiryTimestampMs + ", maxTimestampMs=" + this.maxTimestampMs + ", tokenId=" + (this.tokenId == null ? "null" : "'" + this.tokenId.toString() + "'") + ", hmac=" + Arrays.toString(this.hmac) + ", throttleTimeMs=" + this.throttleTimeMs + ")";
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String principalType() {
        return this.principalType;
    }

    public String principalName() {
        return this.principalName;
    }

    public long issueTimestampMs() {
        return this.issueTimestampMs;
    }

    public long expiryTimestampMs() {
        return this.expiryTimestampMs;
    }

    public long maxTimestampMs() {
        return this.maxTimestampMs;
    }

    public String tokenId() {
        return this.tokenId;
    }

    public byte[] hmac() {
        return this.hmac;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public CreateDelegationTokenResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public CreateDelegationTokenResponseData setPrincipalType(String v) {
        this.principalType = v;
        return this;
    }

    public CreateDelegationTokenResponseData setPrincipalName(String v) {
        this.principalName = v;
        return this;
    }

    public CreateDelegationTokenResponseData setIssueTimestampMs(long v) {
        this.issueTimestampMs = v;
        return this;
    }

    public CreateDelegationTokenResponseData setExpiryTimestampMs(long v) {
        this.expiryTimestampMs = v;
        return this;
    }

    public CreateDelegationTokenResponseData setMaxTimestampMs(long v) {
        this.maxTimestampMs = v;
        return this;
    }

    public CreateDelegationTokenResponseData setTokenId(String v) {
        this.tokenId = v;
        return this;
    }

    public CreateDelegationTokenResponseData setHmac(byte[] v) {
        this.hmac = v;
        return this;
    }

    public CreateDelegationTokenResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The top-level error, or zero if there was no error."), new Field("principal_type", Type.STRING, "The principal type of the token owner."), new Field("principal_name", Type.STRING, "The name of the token owner."), new Field("issue_timestamp_ms", Type.INT64, "When this token was generated."), new Field("expiry_timestamp_ms", Type.INT64, "When this token expires."), new Field("max_timestamp_ms", Type.INT64, "The maximum lifetime of this token."), new Field("token_id", Type.STRING, "The token UUID."), new Field("hmac", Type.BYTES, "HMAC of the delegation token."), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."));
        SCHEMA_2 = new Schema(new Field("error_code", Type.INT16, "The top-level error, or zero if there was no error."), new Field("principal_type", Type.COMPACT_STRING, "The principal type of the token owner."), new Field("principal_name", Type.COMPACT_STRING, "The name of the token owner."), new Field("issue_timestamp_ms", Type.INT64, "When this token was generated."), new Field("expiry_timestamp_ms", Type.INT64, "When this token expires."), new Field("max_timestamp_ms", Type.INT64, "The maximum lifetime of this token."), new Field("token_id", Type.COMPACT_STRING, "The token UUID."), new Field("hmac", Type.COMPACT_BYTES, "HMAC of the delegation token."), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }
}

