/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.kinesis;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.data.input.kinesis.KinesisInputReader;
import org.apache.druid.data.input.kinesis.KinesisRecordEntity;
import org.apache.druid.indexing.seekablestream.SettableByteEntity;
import org.apache.druid.java.util.common.DateTimes;

public class KinesisInputFormat
implements InputFormat {
    private static final String DEFAULT_TIMESTAMP_COLUMN_NAME = "kinesis.timestamp";
    private static final String DEFAULT_PARTITION_KEY_COLUMN_NAME = "kinesis.partitionKey";
    public static final String DEFAULT_AUTO_TIMESTAMP_STRING = "__kif_auto_timestamp";
    private final TimestampSpec dummyTimestampSpec = new TimestampSpec("__kif_auto_timestamp", "auto", DateTimes.EPOCH);
    private final InputFormat valueFormat;
    private final String timestampColumnName;
    private final String partitionKeyColumnName;

    public KinesisInputFormat(@JsonProperty(value="valueFormat") InputFormat valueFormat, @JsonProperty(value="partitionKeyColumnName") @Nullable String partitionKeyColumnName, @JsonProperty(value="timestampColumnName") @Nullable String timestampColumnName) {
        this.valueFormat = (InputFormat)Preconditions.checkNotNull((Object)valueFormat, (Object)"valueFormat must not be null");
        Preconditions.checkState((timestampColumnName == null || !timestampColumnName.equals(partitionKeyColumnName) ? 1 : 0) != 0, (Object)"timestampColumnName and partitionKeyColumnName must be different");
        this.partitionKeyColumnName = partitionKeyColumnName != null ? partitionKeyColumnName : DEFAULT_PARTITION_KEY_COLUMN_NAME;
        this.timestampColumnName = timestampColumnName != null ? timestampColumnName : DEFAULT_TIMESTAMP_COLUMN_NAME;
    }

    public boolean isSplittable() {
        return false;
    }

    public InputEntityReader createReader(InputRowSchema inputRowSchema, InputEntity source, File temporaryDirectory) {
        SettableByteEntity settableByteEntitySource;
        if (source instanceof SettableByteEntity) {
            settableByteEntitySource = (SettableByteEntity)source;
        } else {
            settableByteEntitySource = new SettableByteEntity();
            settableByteEntitySource.setEntity((ByteEntity)((KinesisRecordEntity)source));
        }
        InputRowSchema newInputRowSchema = new InputRowSchema(this.dummyTimestampSpec, inputRowSchema.getDimensionsSpec(), inputRowSchema.getColumnsFilter(), inputRowSchema.getMetricNames());
        return new KinesisInputReader(inputRowSchema, (SettableByteEntity<KinesisRecordEntity>)settableByteEntitySource, JsonInputFormat.withLineSplittable((InputFormat)this.valueFormat, (boolean)false).createReader(newInputRowSchema, source, temporaryDirectory), this.partitionKeyColumnName, this.timestampColumnName);
    }

    @JsonProperty
    public InputFormat getValueFormat() {
        return this.valueFormat;
    }

    @Nullable
    @JsonProperty
    public String getTimestampColumnName() {
        return this.timestampColumnName;
    }

    @Nullable
    @JsonProperty
    public String getPartitionKeyColumnName() {
        return this.partitionKeyColumnName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KinesisInputFormat that = (KinesisInputFormat)o;
        return Objects.equals(this.valueFormat, that.valueFormat) && Objects.equals(this.timestampColumnName, that.timestampColumnName) && Objects.equals(this.partitionKeyColumnName, that.partitionKeyColumnName);
    }

    public int hashCode() {
        return Objects.hash(this.valueFormat, this.timestampColumnName, this.partitionKeyColumnName);
    }
}

