/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.supervisor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;
import org.apache.druid.error.DruidException;
import org.apache.druid.indexing.overlord.supervisor.NoopSupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.Supervisor;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.SupervisorTaskAutoScaler;
import org.apache.druid.server.security.ResourceAction;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="NoopSupervisorSpec", value=NoopSupervisorSpec.class)})
public interface SupervisorSpec {
    public String getId();

    public Supervisor createSupervisor();

    default public SupervisorTaskAutoScaler createAutoscaler(Supervisor supervisor) {
        return null;
    }

    public List<String> getDataSources();

    default public SupervisorSpec createSuspendedSpec() {
        throw new UnsupportedOperationException();
    }

    default public SupervisorSpec createRunningSpec() {
        throw new UnsupportedOperationException();
    }

    default public boolean isSuspended() {
        return false;
    }

    public String getType();

    @JsonIgnore
    @Nonnull
    default public Set<ResourceAction> getInputSourceResources() throws UnsupportedOperationException {
        throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.UNSUPPORTED).build("Supervisor type[%s] does not support input source based security", new Object[]{this.getType()});
    }

    public String getSource();

    default public void validateSpecUpdateTo(SupervisorSpec proposedSpec) throws DruidException {
    }

    default public void merge(@NotNull SupervisorSpec existingSpec) {
    }
}

