/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import org.apache.druid.query.ResultSerializationMode;

public class ClientQuerySegmentWalkerUtils {
    public static SubqueryResultLimit getLimitType(long memoryLimitBytes, boolean cannotMaterializeToFrames) {
        if (cannotMaterializeToFrames) {
            return SubqueryResultLimit.ROW_LIMIT;
        }
        if (memoryLimitBytes > 0L) {
            return SubqueryResultLimit.MEMORY_LIMIT;
        }
        return SubqueryResultLimit.ROW_LIMIT;
    }

    public static enum SubqueryResultLimit {
        ROW_LIMIT{

            @Override
            public ResultSerializationMode serializationMode() {
                return ResultSerializationMode.ROWS;
            }
        }
        ,
        MEMORY_LIMIT{

            @Override
            public ResultSerializationMode serializationMode() {
                return ResultSerializationMode.FRAMES;
            }
        };


        public abstract ResultSerializationMode serializationMode();
    }
}

