/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.compaction;

import java.util.HashMap;
import java.util.Map;
import org.apache.druid.server.compaction.CompactionCandidate;
import org.apache.druid.server.coordinator.AutoCompactionSnapshot;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.server.coordinator.stats.RowKey;
import org.apache.druid.server.coordinator.stats.Stats;

public class CompactionSnapshotBuilder {
    private final CoordinatorRunStats stats;
    private final Map<String, AutoCompactionSnapshot.Builder> datasourceToBuilder = new HashMap<String, AutoCompactionSnapshot.Builder>();

    public CompactionSnapshotBuilder(CoordinatorRunStats runStats) {
        this.stats = runStats;
    }

    public void addToComplete(CompactionCandidate candidate) {
        this.getBuilderForDatasource(candidate.getDataSource()).incrementCompactedStats(candidate.getStats());
    }

    public void addToPending(CompactionCandidate candidate) {
        this.getBuilderForDatasource(candidate.getDataSource()).incrementWaitingStats(candidate.getStats());
    }

    public void addToSkipped(CompactionCandidate candidate) {
        this.getBuilderForDatasource(candidate.getDataSource()).incrementSkippedStats(candidate.getStats());
    }

    public void moveFromPendingToSkipped(CompactionCandidate candidate) {
        this.getBuilderForDatasource(candidate.getDataSource()).decrementWaitingStats(candidate.getStats());
        this.addToSkipped(candidate);
    }

    public void moveFromPendingToCompleted(CompactionCandidate candidate) {
        this.getBuilderForDatasource(candidate.getDataSource()).decrementWaitingStats(candidate.getStats());
        this.addToComplete(candidate);
    }

    public Map<String, AutoCompactionSnapshot> build() {
        HashMap<String, AutoCompactionSnapshot> datasourceToSnapshot = new HashMap<String, AutoCompactionSnapshot>();
        this.datasourceToBuilder.forEach((dataSource, builder) -> {
            AutoCompactionSnapshot autoCompactionSnapshot = builder.build();
            datasourceToSnapshot.put((String)dataSource, autoCompactionSnapshot);
            this.collectSnapshotStats(autoCompactionSnapshot);
        });
        return datasourceToSnapshot;
    }

    private AutoCompactionSnapshot.Builder getBuilderForDatasource(String dataSource) {
        return this.datasourceToBuilder.computeIfAbsent(dataSource, AutoCompactionSnapshot::builder);
    }

    private void collectSnapshotStats(AutoCompactionSnapshot autoCompactionSnapshot) {
        RowKey rowKey = RowKey.of(Dimension.DATASOURCE, autoCompactionSnapshot.getDataSource());
        this.stats.add(Stats.Compaction.PENDING_BYTES, rowKey, autoCompactionSnapshot.getBytesAwaitingCompaction());
        this.stats.add(Stats.Compaction.PENDING_SEGMENTS, rowKey, autoCompactionSnapshot.getSegmentCountAwaitingCompaction());
        this.stats.add(Stats.Compaction.PENDING_INTERVALS, rowKey, autoCompactionSnapshot.getIntervalCountAwaitingCompaction());
        this.stats.add(Stats.Compaction.COMPACTED_BYTES, rowKey, autoCompactionSnapshot.getBytesCompacted());
        this.stats.add(Stats.Compaction.COMPACTED_SEGMENTS, rowKey, autoCompactionSnapshot.getSegmentCountCompacted());
        this.stats.add(Stats.Compaction.COMPACTED_INTERVALS, rowKey, autoCompactionSnapshot.getIntervalCountCompacted());
        this.stats.add(Stats.Compaction.SKIPPED_BYTES, rowKey, autoCompactionSnapshot.getBytesSkipped());
        this.stats.add(Stats.Compaction.SKIPPED_SEGMENTS, rowKey, autoCompactionSnapshot.getSegmentCountSkipped());
        this.stats.add(Stats.Compaction.SKIPPED_INTERVALS, rowKey, autoCompactionSnapshot.getIntervalCountSkipped());
    }
}

