/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexPhaseRunner;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskReport;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskSpec;

abstract class InputSourceSplitParallelIndexTaskRunner<T extends Task, R extends SubTaskReport>
extends ParallelIndexPhaseRunner<T, R> {
    private final ParallelIndexIngestionSpec ingestionSchema;
    private final SplittableInputSource<?> baseInputSource;

    InputSourceSplitParallelIndexTaskRunner(TaskToolbox toolbox, String taskId, String groupId, String baseSubtaskSpecName, ParallelIndexIngestionSpec ingestionSchema, Map<String, Object> context) {
        super(toolbox, taskId, groupId, baseSubtaskSpecName, ingestionSchema.getTuningConfig(), context);
        this.ingestionSchema = ingestionSchema;
        this.baseInputSource = (SplittableInputSource)ingestionSchema.getIOConfig().getNonNullInputSource(toolbox);
    }

    @Override
    Iterator<SubTaskSpec<T>> subTaskSpecIterator() throws IOException {
        return this.baseInputSource.createSplits(this.ingestionSchema.getIOConfig().getInputFormat(), this.getTuningConfig().getSplitHintSpec()).map(this::newTaskSpec).iterator();
    }

    @Override
    final int estimateTotalNumSubTasks() throws IOException {
        return this.baseInputSource.estimateNumSplits(this.ingestionSchema.getIOConfig().getInputFormat(), this.getTuningConfig().getSplitHintSpec());
    }

    final SubTaskSpec<T> newTaskSpec(InputSplit split) {
        InputSource inputSource = this.baseInputSource.withSplit(split);
        ParallelIndexIngestionSpec subTaskIngestionSpec = new ParallelIndexIngestionSpec(this.ingestionSchema.getDataSchema(), new ParallelIndexIOConfig(inputSource, this.ingestionSchema.getIOConfig().getInputFormat(), this.ingestionSchema.getIOConfig().isAppendToExisting(), this.ingestionSchema.getIOConfig().isDropExisting()), this.ingestionSchema.getTuningConfig());
        return this.createSubTaskSpec(this.getBaseSubtaskSpecName() + "_" + this.getAndIncrementNextSpecId(), this.getGroupId(), this.getTaskId(), this.getContext(), split, subTaskIngestionSpec);
    }

    abstract SubTaskSpec<T> createSubTaskSpec(String var1, String var2, String var3, Map<String, Object> var4, InputSplit var5, ParallelIndexIngestionSpec var6);
}

