/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.compact;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.broker.BrokerClient;
import org.apache.druid.client.indexing.ClientCompactionTaskQuery;
import org.apache.druid.client.indexing.ClientTaskQuery;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.actions.TaskActionClientFactory;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.compact.CompactionJob;
import org.apache.druid.indexing.compact.CompactionJobParams;
import org.apache.druid.indexing.compact.CompactionSupervisor;
import org.apache.druid.indexing.input.DruidInputSource;
import org.apache.druid.indexing.overlord.GlobalTaskLockbox;
import org.apache.druid.indexing.template.BatchIndexingJob;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Stopwatch;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.http.SqlTaskStatus;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.server.compaction.CompactionCandidate;
import org.apache.druid.server.compaction.CompactionCandidateSearchPolicy;
import org.apache.druid.server.compaction.CompactionSlotManager;
import org.apache.druid.server.compaction.CompactionSnapshotBuilder;
import org.apache.druid.server.compaction.CompactionStatus;
import org.apache.druid.server.compaction.CompactionStatusTracker;
import org.apache.druid.server.coordinator.AutoCompactionSnapshot;
import org.apache.druid.server.coordinator.ClusterCompactionConfig;
import org.apache.druid.server.coordinator.CompactionConfigValidationResult;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.server.coordinator.stats.RowKey;
import org.apache.druid.server.coordinator.stats.Stats;

@NotThreadSafe
public class CompactionJobQueue {
    private static final Logger log = new Logger(CompactionJobQueue.class);
    private final CompactionJobParams jobParams;
    private final CompactionCandidateSearchPolicy searchPolicy;
    private final ClusterCompactionConfig clusterCompactionConfig;
    private final ObjectMapper objectMapper;
    private final CompactionStatusTracker statusTracker;
    private final TaskActionClientFactory taskActionClientFactory;
    private final OverlordClient overlordClient;
    private final GlobalTaskLockbox taskLockbox;
    private final BrokerClient brokerClient;
    private final CompactionSnapshotBuilder snapshotBuilder;
    private final PriorityQueue<CompactionJob> queue;
    private final CoordinatorRunStats runStats = new CoordinatorRunStats();
    private final Set<String> activeSupervisors;
    private final Map<String, CompactionJob> submittedTaskIdToJob;

    public CompactionJobQueue(DataSourcesSnapshot dataSourcesSnapshot, ClusterCompactionConfig clusterCompactionConfig, CompactionStatusTracker statusTracker, TaskActionClientFactory taskActionClientFactory, GlobalTaskLockbox taskLockbox, OverlordClient overlordClient, BrokerClient brokerClient, ObjectMapper objectMapper) {
        this.snapshotBuilder = new CompactionSnapshotBuilder(this.runStats);
        this.clusterCompactionConfig = clusterCompactionConfig;
        this.searchPolicy = clusterCompactionConfig.getCompactionPolicy();
        this.queue = new PriorityQueue((o1, o2) -> this.searchPolicy.compareCandidates(o1.getCandidate(), o2.getCandidate()));
        this.submittedTaskIdToJob = new HashMap<String, CompactionJob>();
        this.activeSupervisors = new HashSet<String>();
        this.jobParams = new CompactionJobParams(DateTimes.nowUtc(), clusterCompactionConfig, dataSourcesSnapshot.getUsedSegmentsTimelinesPerDataSource()::get, this.snapshotBuilder);
        this.taskActionClientFactory = taskActionClientFactory;
        this.overlordClient = overlordClient;
        this.brokerClient = brokerClient;
        this.statusTracker = statusTracker;
        this.objectMapper = objectMapper;
        this.taskLockbox = taskLockbox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAndEnqueueJobs(CompactionSupervisor supervisor, DruidInputSource source) {
        Stopwatch jobCreationTime = Stopwatch.createStarted();
        String supervisorId = supervisor.getSpec().getId();
        try {
            if (supervisor.shouldCreateJobs() && !this.activeSupervisors.contains(supervisorId)) {
                List<CompactionJob> jobs = supervisor.createJobs(source, this.jobParams);
                jobs.forEach(job -> this.snapshotBuilder.addToPending(job.getCandidate()));
                this.queue.addAll(jobs);
                this.activeSupervisors.add(supervisorId);
                this.runStats.add(Stats.Compaction.CREATED_JOBS, RowKey.of((Dimension)Dimension.DATASOURCE, (String)source.getDataSource()), (long)jobs.size());
            } else {
                log.debug("Skipping job creation for supervisor[%s]", new Object[]{supervisorId});
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error while creating jobs for supervisor[%s]", new Object[]{supervisorId});
        }
        finally {
            this.runStats.add(Stats.Compaction.JOB_CREATION_TIME, RowKey.of((Dimension)Dimension.DATASOURCE, (String)source.getDataSource()), jobCreationTime.millisElapsed());
        }
    }

    public void removeJobs(String dataSource) {
        List jobsToRemove = this.queue.stream().filter(job -> job.getDataSource().equals(dataSource)).collect(Collectors.toList());
        this.queue.removeAll(jobsToRemove);
        log.info("Removed [%d] jobs for datasource[%s] from queue.", new Object[]{jobsToRemove.size(), dataSource});
    }

    public void runReadyJobs() {
        CompactionSlotManager slotManager = new CompactionSlotManager(this.overlordClient, this.statusTracker, this.clusterCompactionConfig);
        slotManager.reserveTaskSlotsForRunningCompactionTasks();
        ArrayList<CompactionJob> pendingJobs = new ArrayList<CompactionJob>();
        while (!this.queue.isEmpty()) {
            CompactionJob job = this.queue.poll();
            if (!this.startJobIfPendingAndReady(job, this.searchPolicy, pendingJobs, slotManager)) continue;
            this.runStats.add(Stats.Compaction.SUBMITTED_TASKS, RowKey.of((Dimension)Dimension.DATASOURCE, (String)job.getDataSource()), 1L);
        }
        this.queue.addAll(pendingJobs);
    }

    public void onTaskFinished(String taskId, TaskStatus taskStatus) {
        CompactionJob job = this.submittedTaskIdToJob.remove(taskId);
        if (job == null || !taskStatus.getStatusCode().isComplete()) {
            return;
        }
        if (taskStatus.getStatusCode() == TaskState.FAILED) {
            this.queue.add(job);
        } else {
            this.snapshotBuilder.moveFromPendingToCompleted(job.getCandidate());
        }
    }

    public CoordinatorRunStats getRunStats() {
        return this.runStats;
    }

    public Map<String, AutoCompactionSnapshot> getSnapshots() {
        return this.snapshotBuilder.build();
    }

    private boolean startJobIfPendingAndReady(CompactionJob job, CompactionCandidateSearchPolicy policy, List<CompactionJob> pendingJobs, CompactionSlotManager slotManager) {
        CompactionCandidate candidate = job.getCandidate();
        CompactionConfigValidationResult validationResult = CompactionJobQueue.validateCompactionJob(job);
        if (!validationResult.isValid()) {
            log.error("Skipping invalid compaction job[%s] due to reason[%s].", new Object[]{job, validationResult.getReason()});
            this.snapshotBuilder.moveFromPendingToSkipped(candidate);
            return false;
        }
        CompactionStatus compactionStatus = this.getCurrentStatusForJob(job, policy);
        switch (compactionStatus.getState()) {
            case RUNNING: {
                return false;
            }
            case COMPLETE: {
                this.snapshotBuilder.moveFromPendingToCompleted(candidate);
                return false;
            }
            case SKIPPED: {
                this.snapshotBuilder.moveFromPendingToSkipped(candidate);
                return false;
            }
        }
        if (job.getMaxRequiredTaskSlots() > slotManager.getNumAvailableTaskSlots()) {
            pendingJobs.add(job);
            return false;
        }
        slotManager.reserveTaskSlots(job.getMaxRequiredTaskSlots());
        String taskId = this.startTaskIfReady(job);
        if (taskId == null) {
            this.snapshotBuilder.moveFromPendingToSkipped(candidate);
            return false;
        }
        this.statusTracker.onTaskSubmitted(taskId, job.getCandidate());
        this.submittedTaskIdToJob.put(taskId, job);
        return true;
    }

    @Nullable
    private String startTaskIfReady(CompactionJob job) {
        if (job.isMsq()) {
            try {
                return ((SqlTaskStatus)FutureUtils.getUnchecked((ListenableFuture)this.brokerClient.submitSqlTask(job.getNonNullMsqQuery()), (boolean)true)).getTaskId();
            }
            catch (Exception e) {
                log.error((Throwable)e, "Error while submitting query[%s] to Broker", new Object[]{job.getNonNullMsqQuery()});
            }
        }
        ClientTaskQuery taskQuery = job.getNonNullTask();
        Task task = (Task)this.objectMapper.convertValue((Object)taskQuery, Task.class);
        log.debug("Checking readiness of task[%s] with interval[%s]", new Object[]{task.getId(), job.getCandidate().getCompactionInterval()});
        try {
            this.taskLockbox.add(task);
            if (task.isReady(this.taskActionClientFactory.create(task))) {
                FutureUtils.getUnchecked((ListenableFuture)this.overlordClient.runTask(task.getId(), (Object)task), (boolean)true);
                return task.getId();
            }
            this.taskLockbox.unlockAll(task);
            return null;
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error while submitting task[%s] to Overlord", new Object[]{task.getId()});
            this.taskLockbox.unlockAll(task);
            return null;
        }
    }

    public CompactionStatus getCurrentStatusForJob(CompactionJob job, CompactionCandidateSearchPolicy policy) {
        CompactionStatus compactionStatus = this.statusTracker.computeCompactionStatus(job.getCandidate(), policy);
        CompactionCandidate candidatesWithStatus = job.getCandidate().withCurrentStatus(null);
        this.statusTracker.onCompactionStatusComputed(candidatesWithStatus, null);
        return compactionStatus;
    }

    public static CompactionConfigValidationResult validateCompactionJob(BatchIndexingJob job) {
        if (job.isMsq()) {
            return CompactionConfigValidationResult.success();
        }
        ClientTaskQuery task = job.getNonNullTask();
        if (!(task instanceof ClientCompactionTaskQuery)) {
            return CompactionConfigValidationResult.failure((String)"Invalid task type[%s]", (Object[])new Object[]{task.getType()});
        }
        return CompactionConfigValidationResult.success();
    }
}

