/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.io.output;

import com.github.rvesse.airline.io.ControlCodeSource;
import com.github.rvesse.airline.io.ControlTracker;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class OutputStreamControlTracker<T>
extends ControlTracker<T> {
    private final OutputStream output;
    private final Charset charset;

    public OutputStreamControlTracker(OutputStream output, ControlCodeSource<T> provider) {
        this(output, null, provider);
    }

    public OutputStreamControlTracker(OutputStream output, Charset charset, ControlCodeSource<T> provider) {
        super(provider);
        if (output == null) {
            throw new NullPointerException("output cannot be null");
        }
        this.output = output;
        this.charset = charset;
    }

    @Override
    protected void resetInternal(T value) throws IOException {
        String code = this.provider.getResetControlCode(value);
        this.output.write(this.getBytes(code));
    }

    private byte[] getBytes(String code) {
        return this.charset != null ? code.getBytes(this.charset) : code.getBytes();
    }

    @Override
    protected void applyInternal(T value) throws IOException {
        String code = this.provider.getControlCode(value);
        this.output.write(this.getBytes(code));
    }
}

