/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import javax.annotation.Nullable;
import org.apache.calcite.rel.hint.HintPredicates;
import org.apache.calcite.rel.hint.HintStrategyTable;
import org.apache.druid.query.JoinAlgorithm;

public abstract class DruidHint {
    public static final HintStrategyTable HINT_STRATEGY_TABLE = DruidHint.createHintStrategies();

    private static HintStrategyTable createHintStrategies() {
        return HintStrategyTable.builder().hintStrategy("sort_merge", HintPredicates.JOIN).hintStrategy("broadcast", HintPredicates.JOIN).build();
    }

    public static abstract class DruidJoinHint
    extends DruidHint {
        @Nullable
        public static DruidJoinHint fromString(String hintName) {
            switch (hintName) {
                case "broadcast": {
                    return new BroadcastJoinHint();
                }
                case "sort_merge": {
                    return new SortMergeJoinHint();
                }
            }
            return null;
        }

        abstract JoinAlgorithm asJoinAlgorithm();

        abstract String id();

        public static class BroadcastJoinHint
        extends DruidJoinHint {
            static final String BROADCAST_JOIN = "broadcast";

            @Override
            String id() {
                return BROADCAST_JOIN;
            }

            @Override
            public JoinAlgorithm asJoinAlgorithm() {
                return JoinAlgorithm.BROADCAST;
            }
        }

        public static class SortMergeJoinHint
        extends DruidJoinHint {
            static final String SORT_MERGE_JOIN = "sort_merge";

            @Override
            String id() {
                return SORT_MERGE_JOIN;
            }

            @Override
            public JoinAlgorithm asJoinAlgorithm() {
                return JoinAlgorithm.SORT_MERGE;
            }
        }
    }
}

