/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.sql.calcite.run.SqlEngine;

public class SqlEngineRegistry {
    private final Map<String, SqlEngine> engines;

    @Inject
    public SqlEngineRegistry(Set<SqlEngine> engineSet) {
        this.engines = engineSet.stream().collect(Collectors.toMap(SqlEngine::name, engine -> engine));
    }

    @NotNull
    public SqlEngine getEngine(String engineName) {
        SqlEngine engine = this.engines.getOrDefault(engineName == null ? "native" : engineName, null);
        if (engine == null) {
            throw InvalidSqlInput.exception((String)"Unsupported engine[%s]", (Object[])new Object[]{engineName});
        }
        return engine;
    }

    public Set<String> getSupportedEngines() {
        return this.engines.keySet();
    }

    public Collection<SqlEngine> getAllEngines() {
        return this.engines.values();
    }
}

