/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.kerberos;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.security.kerberos.KerberosAuthenticator;
import org.apache.druid.security.kerberos.KerberosHttpClient;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Escalator;

@JsonTypeName(value="kerberos")
public class KerberosEscalator
implements Escalator {
    private static final Logger log = new Logger(KerberosAuthenticator.class);
    private final String internalClientPrincipal;
    private final String internalClientKeytab;
    private final String authorizerName;

    @JsonCreator
    public KerberosEscalator(@JsonProperty(value="authorizerName") String authorizerName, @JsonProperty(value="internalClientPrincipal") String internalClientPrincipal, @JsonProperty(value="internalClientKeytab") String internalClientKeytab) {
        this.authorizerName = authorizerName;
        this.internalClientPrincipal = internalClientPrincipal;
        this.internalClientKeytab = internalClientKeytab;
    }

    public HttpClient createEscalatedClient(HttpClient baseClient) {
        return new KerberosHttpClient(baseClient, this.internalClientPrincipal, this.internalClientKeytab);
    }

    public AuthenticationResult createEscalatedAuthenticationResult() {
        return new AuthenticationResult(this.internalClientPrincipal, this.authorizerName, null, null);
    }
}

