/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.path;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.druid.indexer.HadoopDruidIndexerConfig;
import org.apache.druid.indexer.path.HadoopGlobPathSplitter;
import org.apache.druid.indexer.path.PathSpec;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.CombineTextInputFormat;
import org.apache.hadoop.mapreduce.lib.input.MultipleInputs;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;

public class StaticPathSpec
implements PathSpec {
    private static final Logger log = new Logger(StaticPathSpec.class);
    private final String paths;
    private final Class<? extends InputFormat> inputFormat;

    @JsonCreator
    public StaticPathSpec(@JsonProperty(value="paths") String paths, @JsonProperty(value="inputFormat") Class<? extends InputFormat> inputFormat) {
        this.paths = paths;
        this.inputFormat = inputFormat;
    }

    @Override
    public Job addInputPaths(HadoopDruidIndexerConfig config, Job job) {
        log.info("Adding paths[%s]", new Object[]{this.paths});
        StaticPathSpec.addToMultipleInputs(config, job, this.paths, this.inputFormat);
        return job;
    }

    @JsonProperty
    public Class<? extends InputFormat> getInputFormat() {
        return this.inputFormat;
    }

    @JsonProperty
    public String getPaths() {
        return this.paths;
    }

    public static void addToMultipleInputs(HadoopDruidIndexerConfig config, Job job, String path, Class<? extends InputFormat> inputFormatClass) {
        if (path != null) {
            StaticPathSpec.addToMultipleInputs(config, job, (Set<String>)ImmutableSet.of((Object)path), inputFormatClass);
        }
    }

    public static void addToMultipleInputs(HadoopDruidIndexerConfig config, Job job, Set<String> paths, Class<? extends InputFormat> inputFormatClass) {
        if (paths == null || paths.isEmpty()) {
            return;
        }
        Class inputFormatClassToUse = inputFormatClass;
        if (inputFormatClassToUse == null) {
            inputFormatClassToUse = config.isCombineText() ? CombineTextInputFormat.class : TextInputFormat.class;
        }
        LinkedHashSet<String> pathStrings = new LinkedHashSet<String>();
        for (String path : paths) {
            Iterables.addAll(pathStrings, HadoopGlobPathSplitter.splitGlob(path));
        }
        if (!pathStrings.isEmpty()) {
            StaticPathSpec.addInputPath(job, pathStrings, inputFormatClassToUse);
        }
    }

    private static void addInputPath(Job job, Iterable<String> pathStrings, Class<? extends InputFormat> inputFormatClass) {
        Configuration conf = job.getConfiguration();
        StringBuilder inputFormats = new StringBuilder(StringUtils.nullToEmptyNonDruidDataString((String)conf.get("mapreduce.input.multipleinputs.dir.formats")));
        String[] paths = (String[])Iterables.toArray(pathStrings, String.class);
        for (int i = 0; i < paths.length - 1; ++i) {
            if (inputFormats.length() > 0) {
                inputFormats.append(',');
            }
            inputFormats.append(paths[i]).append(';').append(inputFormatClass.getName());
        }
        if (inputFormats.length() > 0) {
            conf.set("mapreduce.input.multipleinputs.dir.formats", inputFormats.toString());
        }
        MultipleInputs.addInputPath((Job)job, (Path)new Path(paths[paths.length - 1]), inputFormatClass);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StaticPathSpec that = (StaticPathSpec)o;
        if (this.paths != null ? !this.paths.equals(that.paths) : that.paths != null) {
            return false;
        }
        return !(this.inputFormat == null ? that.inputFormat != null : !this.inputFormat.equals(that.inputFormat));
    }

    public int hashCode() {
        int result = this.paths != null ? this.paths.hashCode() : 0;
        result = 31 * result + (this.inputFormat != null ? this.inputFormat.hashCode() : 0);
        return result;
    }
}

