/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.streaming.api.functions.python;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.types.Row;

/**
 * {@link KeyByKeySelector} is responsible for extracting the first field of the input row as key.
 * The input row is generated by python DataStream map function in the format of
 * (key_selector.get_key(value), value) tuple2.
 */
@Internal
public class KeyByKeySelector implements KeySelector<Row, Row> {
    private static final long serialVersionUID = 1L;

    @Override
    public Row getKey(Row value) {
        Object realKey = value.getField(0);
        Row wrapper = new Row(1);
        wrapper.setField(0, realKey);
        return wrapper;
    }
}
