/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.table.planner.operations.converters;

import org.apache.flink.sql.parser.ddl.SqlCreateCatalog;
import org.apache.flink.sql.parser.ddl.SqlTableOption;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ddl.CreateCatalogOperation;

import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.util.NlsString;

import java.util.HashMap;
import java.util.Map;

/** A converter for {@link SqlCreateCatalog}. */
public class SqlCreateCatalogConverter implements SqlNodeConverter<SqlCreateCatalog> {

    @Override
    public Operation convertSqlNode(SqlCreateCatalog node, ConvertContext context) {
        // set with properties
        Map<String, String> properties = new HashMap<>();
        node.getPropertyList()
                .getList()
                .forEach(
                        p ->
                                properties.put(
                                        ((SqlTableOption) p).getKeyString(),
                                        ((SqlTableOption) p).getValueString()));

        return new CreateCatalogOperation(
                node.catalogName(),
                properties,
                node.getComment()
                        .map(SqlCharStringLiteral.class::cast)
                        .map(c -> c.getValueAs(NlsString.class).getValue())
                        .orElse(null),
                node.isIfNotExists());
    }
}
