/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleGaugeBuilder;
import io.opentelemetry.api.metrics.LongGaugeBuilder;
import io.opentelemetry.api.metrics.ObservableDoubleGauge;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.context.Context;
import io.opentelemetry.extension.incubator.metrics.DoubleGauge;
import io.opentelemetry.extension.incubator.metrics.DoubleGaugeAdviceConfigurer;
import io.opentelemetry.extension.incubator.metrics.ExtendedDoubleGaugeBuilder;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrumentBuilder;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.InstrumentValueType;
import io.opentelemetry.sdk.metrics.SdkLongGauge;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.List;
import java.util.function.Consumer;

final class SdkDoubleGauge
extends AbstractInstrument
implements DoubleGauge {
    private final WriteableMetricStorage storage;

    private SdkDoubleGauge(InstrumentDescriptor descriptor, WriteableMetricStorage storage) {
        super(descriptor);
        this.storage = storage;
    }

    @Override
    public void set(double increment, Attributes attributes) {
        this.storage.recordDouble(increment, attributes, Context.root());
    }

    @Override
    public void set(double increment) {
        this.set(increment, Attributes.empty());
    }

    static final class SdkDoubleGaugeBuilder
    extends AbstractInstrumentBuilder<SdkDoubleGaugeBuilder>
    implements ExtendedDoubleGaugeBuilder,
    DoubleGaugeAdviceConfigurer {
        SdkDoubleGaugeBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, String name) {
            super(meterProviderSharedState, meterSharedState, InstrumentType.OBSERVABLE_GAUGE, InstrumentValueType.DOUBLE, name, "", "");
        }

        @Override
        protected SdkDoubleGaugeBuilder getThis() {
            return this;
        }

        @Override
        public SdkDoubleGauge build() {
            return this.buildSynchronousInstrument((x$0, x$1) -> new SdkDoubleGauge((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }

        @Override
        public DoubleGaugeBuilder setAdvice(Consumer<DoubleGaugeAdviceConfigurer> adviceConsumer) {
            adviceConsumer.accept(this);
            return this;
        }

        @Override
        public DoubleGaugeAdviceConfigurer setAttributes(List<AttributeKey<?>> attributes) {
            this.adviceBuilder.setAttributes(attributes);
            return this;
        }

        @Override
        public LongGaugeBuilder ofLongs() {
            return this.swapBuilder(SdkLongGauge.SdkLongGaugeBuilder::new);
        }

        @Override
        public ObservableDoubleGauge buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            return this.registerDoubleAsynchronousInstrument(InstrumentType.OBSERVABLE_GAUGE, callback);
        }

        @Override
        public ObservableDoubleMeasurement buildObserver() {
            return this.buildObservableMeasurement(InstrumentType.OBSERVABLE_GAUGE);
        }
    }
}

