/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.correlate.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.streaming.api.functions.async.CollectionSupplier;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.streaming.api.functions.async.RichAsyncFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.generated.GeneratedFunction;

public class AsyncCorrelateRunner
extends RichAsyncFunction<RowData, RowData> {
    private static final long serialVersionUID = 1L;
    private final GeneratedFunction<AsyncFunction<RowData, Object>> generatedFetcher;
    private final DataStructureConverter<RowData, Object> fetcherConverter;
    private transient AsyncFunction<RowData, Object> fetcher;

    public AsyncCorrelateRunner(GeneratedFunction<AsyncFunction<RowData, Object>> generatedFetcher, DataStructureConverter<RowData, Object> fetcherConverter) {
        this.generatedFetcher = generatedFetcher;
        this.fetcherConverter = fetcherConverter;
    }

    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        ClassLoader cl = this.getRuntimeContext().getUserCodeClassLoader();
        this.fetcher = (AsyncFunction)this.generatedFetcher.newInstance(cl);
        FunctionUtils.setFunctionRuntimeContext(this.fetcher, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.fetcher, (OpenContext)openContext);
        this.fetcherConverter.open(cl);
    }

    public void asyncInvoke(RowData input, ResultFuture<RowData> resultFuture) throws Exception {
        try {
            JoinedRowResultFuture outResultFuture = new JoinedRowResultFuture(input, resultFuture, this.fetcherConverter);
            this.fetcher.asyncInvoke((Object)input, (ResultFuture)outResultFuture);
        }
        catch (Throwable t) {
            resultFuture.completeExceptionally(t);
        }
    }

    public void close() throws Exception {
        super.close();
        FunctionUtils.closeFunction(this.fetcher);
    }

    private static final class JoinedRowResultFuture
    implements ResultFuture<Object> {
        private final DataStructureConverter<RowData, Object> resultConverter;
        private RowData leftRow;
        private ResultFuture<RowData> realOutput;

        private JoinedRowResultFuture(RowData row, ResultFuture<RowData> resultFuture, DataStructureConverter<RowData, Object> resultConverter) {
            this.leftRow = row;
            this.realOutput = resultFuture;
            this.resultConverter = resultConverter;
        }

        public void complete(Collection<Object> result) {
            try {
                Collection<RowData> rightRows = this.wrapPrimitivesAndConvert(result);
                this.completeResultFuture(rightRows);
            }
            catch (Throwable t) {
                this.realOutput.completeExceptionally(t);
            }
        }

        private void completeResultFuture(Collection<RowData> rightRows) {
            this.realOutput.complete(() -> {
                if (rightRows == null || rightRows.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<JoinedRowData> outRows = new ArrayList<JoinedRowData>();
                for (RowData rightRow : rightRows) {
                    JoinedRowData outRow = new JoinedRowData(this.leftRow.getRowKind(), this.leftRow, rightRow);
                    outRows.add(outRow);
                }
                return outRows;
            });
        }

        private Collection<RowData> wrapPrimitivesAndConvert(Collection<Object> result) {
            Collection<Object> rowDataCollection;
            if (this.resultConverter.isIdentityConversion()) {
                rowDataCollection = result;
            } else {
                rowDataCollection = new ArrayList<Object>(result.size());
                for (Object element : result) {
                    if (element instanceof RowData) {
                        rowDataCollection.add((RowData)element);
                        continue;
                    }
                    rowDataCollection.add(this.resultConverter.toInternal(element));
                }
            }
            return rowDataCollection;
        }

        public void completeExceptionally(Throwable error) {
            this.realOutput.completeExceptionally(error);
        }

        public void complete(CollectionSupplier<Object> supplier) {
            throw new UnsupportedOperationException();
        }

        public void close() throws Exception {
        }
    }
}

