/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.dynamicfiltering;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.runtime.operators.coordination.OperatorEventDispatcher;
import org.apache.flink.runtime.operators.coordination.OperatorEventGateway;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.CoordinatedOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.table.runtime.operators.dynamicfiltering.DynamicFilteringDataCollectorOperator;
import org.apache.flink.table.runtime.operators.dynamicfiltering.DynamicFilteringDataCollectorOperatorCoordinator;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class DynamicFilteringDataCollectorOperatorFactory
extends AbstractStreamOperatorFactory<Object>
implements CoordinatedOperatorFactory<Object> {
    private final Set<String> dynamicFilteringDataListenerIDs = new HashSet<String>();
    private final RowType dynamicFilteringFieldType;
    private final List<Integer> dynamicFilteringFieldIndices;
    private final long threshold;

    public DynamicFilteringDataCollectorOperatorFactory(RowType dynamicFilteringFieldType, List<Integer> dynamicFilteringFieldIndices, long threshold) {
        this.dynamicFilteringFieldType = (RowType)Preconditions.checkNotNull((Object)dynamicFilteringFieldType);
        this.dynamicFilteringFieldIndices = (List)Preconditions.checkNotNull(dynamicFilteringFieldIndices);
        this.threshold = threshold;
    }

    public <T extends StreamOperator<Object>> T createStreamOperator(StreamOperatorParameters<Object> parameters) {
        DynamicFilteringDataCollectorOperator operator;
        OperatorID operatorId = parameters.getStreamConfig().getOperatorID();
        OperatorEventDispatcher eventDispatcher = parameters.getOperatorEventDispatcher();
        OperatorEventGateway operatorEventGateway = eventDispatcher.getOperatorEventGateway(operatorId);
        DynamicFilteringDataCollectorOperator castedOperator = operator = new DynamicFilteringDataCollectorOperator(parameters, this.dynamicFilteringFieldType, this.dynamicFilteringFieldIndices, this.threshold, operatorEventGateway);
        return (T)((Object)castedOperator);
    }

    public void registerDynamicFilteringDataListenerID(String id) {
        this.dynamicFilteringDataListenerIDs.add((String)Preconditions.checkNotNull((Object)id));
    }

    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return DynamicFilteringDataCollectorOperator.class;
    }

    public OperatorCoordinator.Provider getCoordinatorProvider(String operatorName, OperatorID operatorID) {
        return new DynamicFilteringDataCollectorOperatorCoordinator.Provider(operatorID, new ArrayList<String>(this.dynamicFilteringDataListenerIDs));
    }
}

