/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.streaming.api.functions.async.CollectionSupplier;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.table.runtime.operators.AbstractAsyncFunctionRunner;

public class AsyncVectorSearchRunner
extends AbstractAsyncFunctionRunner<RowData> {
    private static final long serialVersionUID = 1L;
    private final boolean isLeftOuterJoin;
    private final int asyncBufferCapacity;
    private final int searchTableFieldCount;
    private transient BlockingQueue<JoinedRowResultFuture> resultFutureBuffer;

    public AsyncVectorSearchRunner(GeneratedFunction<AsyncFunction<RowData, RowData>> generatedFetcher, boolean isLeftOuterJoin, int asyncBufferCapacity, int searchTableFieldCount) {
        super(generatedFetcher);
        this.isLeftOuterJoin = isLeftOuterJoin;
        this.asyncBufferCapacity = asyncBufferCapacity;
        this.searchTableFieldCount = searchTableFieldCount;
    }

    @Override
    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        this.resultFutureBuffer = new ArrayBlockingQueue<JoinedRowResultFuture>(this.asyncBufferCapacity + 1);
        for (int i = 0; i < this.asyncBufferCapacity + 1; ++i) {
            this.resultFutureBuffer.add(new JoinedRowResultFuture(this.resultFutureBuffer, this.isLeftOuterJoin, this.searchTableFieldCount));
        }
    }

    public void asyncInvoke(RowData input, ResultFuture<RowData> resultFuture) throws Exception {
        JoinedRowResultFuture wrapper = this.resultFutureBuffer.take();
        wrapper.reset(input, resultFuture);
        this.fetcher.asyncInvoke((Object)input, (ResultFuture)wrapper);
    }

    private static final class JoinedRowResultFuture
    implements ResultFuture<RowData> {
        private final BlockingQueue<JoinedRowResultFuture> resultFutureBuffer;
        private final boolean isLeftOuterJoin;
        private final GenericRowData nullRow;
        private RowData leftRow;
        private ResultFuture<RowData> realOutput;

        private JoinedRowResultFuture(BlockingQueue<JoinedRowResultFuture> resultFutureBuffer, boolean isLeftOuterJoin, int searchTableArity) {
            this.resultFutureBuffer = resultFutureBuffer;
            this.isLeftOuterJoin = isLeftOuterJoin;
            this.nullRow = new GenericRowData(searchTableArity);
        }

        public void reset(RowData leftRow, ResultFuture<RowData> realOutput) {
            this.leftRow = leftRow;
            this.realOutput = realOutput;
        }

        public void complete(Collection<RowData> result) {
            if (result == null || result.isEmpty()) {
                if (this.isLeftOuterJoin) {
                    JoinedRowData outRow = new JoinedRowData(this.leftRow.getRowKind(), this.leftRow, (RowData)this.nullRow);
                    this.realOutput.complete(Collections.singleton(outRow));
                } else {
                    this.realOutput.complete(Collections.emptyList());
                }
            } else {
                ArrayList<JoinedRowData> outRows = new ArrayList<JoinedRowData>();
                for (RowData right : result) {
                    JoinedRowData outRow = new JoinedRowData(this.leftRow.getRowKind(), this.leftRow, right);
                    outRows.add(outRow);
                }
                this.realOutput.complete(outRows);
            }
            try {
                this.resultFutureBuffer.put(this);
            }
            catch (InterruptedException e) {
                this.completeExceptionally(e);
            }
        }

        public void completeExceptionally(Throwable error) {
            this.realOutput.completeExceptionally(error);
        }

        public void complete(CollectionSupplier<RowData> supplier) {
            throw new UnsupportedOperationException();
        }
    }
}

