/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.DiskStoreCommandsUtils;
import org.apache.geode.management.internal.cli.result.model.DataResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.messages.CompactRequest;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CompactDiskStoreCommand
extends GfshCommand {
    @CliCommand(value={"compact disk-store"}, help="Compact a disk store on all members with that disk store. This command uses the compaction threshold that each member has configured for its disk stores. The disk store must have \"allow-force-compaction\" set to true.")
    @CliMetaData(relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.DISK)
    public ResultModel compactDiskStore(@CliOption(key={"name"}, mandatory=true, optionContext="geode.converter.cluster.diskstore:disable-string-converter", help="Name of the disk store to be compacted.") String diskStoreName, @CliOption(key={"group", "groups"}, help="Group(s) of members that will perform disk compaction. If no group is specified the disk store will be compacted by all members.") String[] groups) {
        ResultModel result = new ResultModel();
        try {
            PersistentID compactedDiskStoreId;
            if (!this.diskStoreExists(diskStoreName)) {
                return ResultModel.createError(CliStrings.format((String)"Disk store \"{0}\" does not exist.", (Object[])new Object[]{diskStoreName}));
            }
            InternalDistributedSystem ds = ((InternalCache)this.getCache()).getInternalDistributedSystem();
            HashMap<InternalDistributedMember, PersistentID> overallCompactInfo = new HashMap<InternalDistributedMember, PersistentID>();
            Set otherMembers = ds.getDistributionManager().getOtherNormalDistributionManagerIds();
            HashSet<InternalDistributedMember> allMembers = new HashSet<InternalDistributedMember>();
            for (Object member : otherMembers) {
                allMembers.add((InternalDistributedMember)member);
            }
            allMembers.add(ds.getDistributedMember());
            String groupInfo = "";
            if (groups != null && groups.length > 0) {
                groupInfo = CliStrings.format((String)" for group(s) \"{0}\"", (Object[])new Object[]{Arrays.toString(groups) + "."});
                HashSet<InternalDistributedMember> selectedMembers = new HashSet<InternalDistributedMember>();
                List<String> targetedGroups = Arrays.asList(groups);
                for (InternalDistributedMember member : allMembers) {
                    List memberGroups = member.getGroups();
                    if (Collections.disjoint(targetedGroups, memberGroups)) continue;
                    selectedMembers.add(member);
                }
                allMembers = selectedMembers;
            }
            if (allMembers.isEmpty()) {
                return ResultModel.createError(CliStrings.format((String)"No members found in the specified group(s) \"{0}\".", (Object[])new Object[]{Arrays.toString(groups)}));
            }
            if (allMembers.remove(ds.getDistributedMember()) && (compactedDiskStoreId = CompactRequest.compactDiskStore((String)diskStoreName)) != null) {
                overallCompactInfo.put(ds.getDistributedMember(), compactedDiskStoreId);
            }
            if (!allMembers.isEmpty()) {
                String notExecutedMembers;
                Map memberCompactInfo = CompactRequest.send((DistributionManager)ds.getDistributionManager(), (String)diskStoreName, allMembers);
                if (memberCompactInfo != null && !memberCompactInfo.isEmpty()) {
                    overallCompactInfo.putAll(memberCompactInfo);
                    memberCompactInfo.clear();
                }
                if ((notExecutedMembers = CompactRequest.getNotExecutedMembers()) != null && !notExecutedMembers.isEmpty()) {
                    LogWrapper.getInstance(this.getCache()).info("compact disk-store \"" + diskStoreName + "\" message was scheduled to be sent to but was not send to " + notExecutedMembers);
                }
            }
            if (!overallCompactInfo.isEmpty()) {
                Set entries = overallCompactInfo.entrySet();
                for (Map.Entry entry : entries) {
                    String memberId = ((DistributedMember)entry.getKey()).getName();
                    DataResultModel summary = result.addData(memberId);
                    summary.setHeader("On Member: " + memberId);
                    PersistentID persistentID = (PersistentID)entry.getValue();
                    if (persistentID == null) continue;
                    summary.addData("UUID", persistentID.getUUID());
                    summary.addData("Host", persistentID.getHost().getHostName());
                    summary.addData("Directory", persistentID.getDirectory());
                }
            } else {
                return ResultModel.createInfo("Attempted to compact disk store, but there was nothing to do.");
            }
            result.addInfo().addLine("Compacted " + diskStoreName + groupInfo);
        }
        catch (RuntimeException e) {
            LogWrapper.getInstance(this.getCache()).info(e.getMessage(), e);
            return ResultModel.createError(CliStrings.format((String)"An error occurred while doing compaction: \"{0}\"", (Object[])new Object[]{e.getMessage()}));
        }
        return result;
    }

    private boolean diskStoreExists(String diskStoreName) {
        Object managementService = this.getManagementService();
        DistributedSystemMXBean dsMXBean = managementService.getDistributedSystemMXBean();
        return Arrays.stream(dsMXBean.listMembers()).anyMatch(member -> DiskStoreCommandsUtils.diskStoreBeanAndMemberBeanDiskStoreExists(dsMXBean, member, diskStoreName));
    }
}

