/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Map;
import java.util.Set;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.commands.OfflineGfshCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class EchoCommand
extends OfflineGfshCommand {
    @CliCommand(value={"echo"}, help="Echo the given text which may include system and user variables.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH"})
    public ResultModel echo(@CliOption(key={"string", ""}, specifiedDefaultValue="", mandatory=true, help="String to be echoed. For example, \"SYS_USER variable is set to ${SYS_USER}\".") String stringToEcho) {
        if (stringToEcho.equals("$*")) {
            Gfsh gfshInstance = this.getGfsh();
            Map<String, String> envMap = gfshInstance.getEnv();
            Set<Map.Entry<String, String>> setEnvMap = envMap.entrySet();
            return this.buildResultForEcho(setEnvMap);
        }
        return ResultModel.createInfo(stringToEcho);
    }

    private ResultModel buildResultForEcho(Set<Map.Entry<String, String>> propertyMap) {
        ResultModel result = new ResultModel();
        TabularResultModel echoResult = result.addTable("echoResult");
        echoResult.setColumnHeader("Property", "Value");
        for (Map.Entry<String, String> setEntry : propertyMap) {
            echoResult.addRow(setEntry.getKey(), String.valueOf(setEntry.getValue()));
        }
        return result;
    }
}

