/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import javax.management.ObjectName;
import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.GatewaySenderMXBean;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.commands.StopGatewaySenderCommand;
import org.apache.geode.management.internal.i18n.CliStrings;

class StopGatewaySenderOnMemberWithBeanImpl
implements StopGatewaySenderCommand.StopGatewaySenderOnMember {
    StopGatewaySenderOnMemberWithBeanImpl() {
    }

    public ArrayList<String> executeStopGatewaySenderOnMember(String id, Cache cache, SystemManagementService managementService, DistributedMember member) {
        GatewaySenderMXBean bean;
        ArrayList<String> statusList = new ArrayList<String>();
        if (cache.getDistributedSystem().getDistributedMember().getId().equals(member.getId())) {
            bean = managementService.getLocalGatewaySenderMXBean(id);
        } else {
            ObjectName objectName = managementService.getGatewaySenderMBeanName(member, id);
            bean = (GatewaySenderMXBean)managementService.getMBeanProxy(objectName, GatewaySenderMXBean.class);
        }
        if (bean == null) {
            statusList.add(member.getId());
            statusList.add("Error");
            statusList.add(CliStrings.format((String)"GatewaySender {0} is not available on member {1}", (Object[])new Object[]{id, member.getId()}));
            return statusList;
        }
        if (!bean.isRunning()) {
            statusList.add(member.getId());
            statusList.add("Error");
            statusList.add(CliStrings.format((String)"GatewaySender {0} is not running on member {1}.", (Object[])new Object[]{id, member.getId()}));
            return statusList;
        }
        bean.stop();
        statusList.add(member.getId());
        statusList.add("OK");
        statusList.add(CliStrings.format((String)"GatewaySender {0} is stopped on member {1}", (Object[])new Object[]{id, member.getId()}));
        return statusList;
    }
}

